﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>

namespace {

char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));

void DummyThread(uintptr_t arg)
{
    NN_UNUSED(arg);
    AutoThreadExit autoExit;
}

} // namespace

TEST(CancelSynchronization, HandleTest)
{
    nn::Result result;
    nn::svc::Handle handle;
    uintptr_t pc = reinterpret_cast<uintptr_t>(DummyThread);;
    uintptr_t sp = reinterpret_cast<uintptr_t>(g_Buffer) + sizeof(g_Buffer);

    // TEST 22-17
    result = nn::svc::CancelSynchronization(nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 22-19
    result = nn::svc::CancelSynchronization(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    result = nn::svc::CreateThread(&handle, pc, 0, sp, TestLowestThreadPriority, 0);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 22-20
    // クローズしたハンドルは受け付けない
    result = nn::svc::CancelSynchronization(handle);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 22-18
    // 自スレッドに対してCancelSynchronization を呼び出すことが出来る
    result = nn::svc::CancelSynchronization(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_SUCCESS(result);

    // 後処理
    // 自スレッドに対してCancelSynchronization を呼んでしまったため、一度キャンセルさせる
    int32_t coreNo = nn::svc::GetCurrentProcessorNumber();
    result = nn::svc::CreateThread(&handle, pc, 0, sp, TestLowestThreadPriority, coreNo);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::StartThread(handle);
    ASSERT_RESULT_SUCCESS(result);

    int32_t index;
    result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultCancelled());

    result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);
}


