﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "sdmmc_IHostController.h"
#include "sdmmc_IDeviceAccessor.h"
#include <nn/TargetConfigs/build_Base.h>
#if (defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_SD_CARD_0_FOR_DEBUG))  // デバッグ用に SD カードポート 0 番に MMC を接続する場合
    #include "sdmmc_MmcDeviceAccessor.h"
#else
    #include "sdmmc_SdCardDeviceAccessor.h"
#endif

namespace nn { namespace sdmmc1 {
namespace detail {

IHostController* GetHostControllerOfPortSdCard0() NN_NOEXCEPT;
IDeviceAccessor* GetDeviceAccessorOfPortSdCard0() NN_NOEXCEPT;
#if (defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_SD_CARD_0_FOR_DEBUG))  // デバッグ用に SD カードポート 0 番に MMC を接続する場合
    MmcDeviceAccessor* GetMmcDeviceAccessorOfPortSdCard0() NN_NOEXCEPT;
#else
    SdCardDeviceAccessor* GetSdCardDeviceAccessorOfPortSdCard0() NN_NOEXCEPT;
#endif

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
