﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "sdmmc_IHostController.h"

namespace nn { namespace sdmmc1 {
namespace detail {

class IDeviceAccessor
{
public:
    virtual void Initialize() NN_NOEXCEPT = 0;
    virtual void Finalize() NN_NOEXCEPT = 0;
    virtual void Deactivate() NN_NOEXCEPT = 0;
    virtual Result ReadWrite(uint32_t sectorIndex, uint32_t numSectors, void* pBuffer, size_t bufferSize, bool isRead) const NN_NOEXCEPT = 0;
    virtual Result GetMemoryCapacity(uint32_t* pOutNumSectors) const NN_NOEXCEPT = 0;
    virtual Result GetDeviceStatus(uint32_t* pOutDeviceStatus) const NN_NOEXCEPT = 0;
    virtual Result GetOcr(uint32_t* pOutOcr) const NN_NOEXCEPT = 0;
    virtual Result GetRca(uint16_t* pOutRca) const NN_NOEXCEPT = 0;
    virtual Result GetCid(void* pOutCid, size_t cidSize) const NN_NOEXCEPT = 0;
    virtual Result GetCsd(void* pOutCsd, size_t csdSize) const NN_NOEXCEPT = 0;
    #if (defined(NN_DETAIL_SDMMC_ISSUE_COMMAND_FOR_DEBUG))
        virtual Result IssueCommandForDebug(uint32_t* pOutResponse, uint32_t commandIndex, uint32_t commandArgument,
            DataTransfer* pDataTransfer, bool isBusy) NN_NOEXCEPT = 0;
    #endif
};

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
