﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include "../../include/nn/i2c/driver/i2c_BusDev.h"

namespace nn {
namespace i2c {
namespace driver {
namespace detail {

struct DeviceSetting
{
    nn::i2c::I2cDevice device;            // デバイス識別子
    int                busIdx;            // デバイス識別子に対応するバス番号
    nn::Bit16          slaveAddress;      // デバイス識別子に対応するスレーブアドレス
    AddressingMode     addressingMode;    // デバイス識別子に対応するアドレスモード
    SpeedMode          speedMode;         // デバイス識別子に対応する動作速度
};

// DeviceSettings をサーチして それぞれのパラメータを返す関数
int            GetBusIdx        ( I2cDevice device ) NN_NOEXCEPT;
nn::Bit16      GetSlaveAddress  ( I2cDevice device ) NN_NOEXCEPT;
AddressingMode GetAddressingMode( I2cDevice device ) NN_NOEXCEPT;
SpeedMode      GetSpeedMode     ( I2cDevice device ) NN_NOEXCEPT;

} // detail
} // driver
} // i2c
} // nn

#if defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6)
    #include "bdsl-imx6/i2c_TargetSpec.bdsl-imx6.h"
#elif defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
    #include "tegra/i2c_TargetSpec.jetson-tk1.h"
#elif defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || (NN_BUILD_CONFIG_HARDWARE_NX)
    #include "tegra/i2c_TargetSpec.jetson-tk2.h"
#else
    #error NN_BUILD_CONFIG_HARDWARE_ not selected or supported
#endif
