﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nnt.h>
#include <nn/nn_Log.h>

#include <nn/spy.h>

#include <nn/spy/detail/fnd/basis/spyfnd_Inlines.h>

TEST(Inlines, Basic)
{
    {
        uint32_t n1 = 0x01234567;
        float f = nn::spy::detail::fnd::Uint32AsFloat(n1);
        uint32_t n2 = nn::spy::detail::fnd::FloatAsUint32(f);
        EXPECT_EQ(n1, n2);
    }

    {
        float f1 = 1234.5f;
        uint32_t n = nn::spy::detail::fnd::FloatAsUint32(f1);
        float f2 = nn::spy::detail::fnd::Uint32AsFloat(n);
        EXPECT_EQ(f1, f2);
    }

    {
        uint64_t n1 = 0x0123456789abcdef;
        double f = nn::spy::detail::fnd::Uint64AsDouble(n1);
        uint64_t n2 = nn::spy::detail::fnd::DoubleAsUint64(f);
        EXPECT_EQ(n1, n2);
    }

    {
        double f1 = 1234.5;
        uint64_t n = nn::spy::detail::fnd::DoubleAsUint64(f1);
        double f2 = nn::spy::detail::fnd::Uint64AsDouble(n);
        EXPECT_EQ(f1, f2);
    }
}
