# VS2017 p̃eXgvWFNgA VS2015 VS2013 p̃eXgvWFNg𐶐܂

$ErrorActionPreference = "Stop"

$scriptPath = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [IO.Path]::GetDirectoryName($ScriptPath)
$utf8BomEncoding = New-Object Text.UTF8Encoding $true

function RewriteVersion
{
    param(
        [string]$infile,
        [string]$outfile,
        [string]$destVersion
    )
    
    Write-Output "$infile => $outfile ($destVersion)"
    
    $text = [IO.File]::ReadAllText($infile)
    $newText = $text
    $newText = $newText.Replace("Debug.15", "Debug.${destVersion}")
    $newText = $newText.Replace("Release.15", "Release.${destVersion}")
    $newText = $newText.Replace("Nintendo.NintendoSdkVsExtension.UnitTest.InIDE.15", "Nintendo.NintendoSdkVsExtension.UnitTest.InIDE.${destVersion}")
    $newText = $newText.Replace("TARGET_IDE_VS15", "TARGET_IDE_VS${destVersion}")
    $newText = $newText.Replace("TestHostFramework, Version=15.0.0.0", "TestHostFramework, Version=${destVersion}.0.0.0")
    [IO.File]::WriteAllText($outfile, $newText, $utf8BomEncoding)
}

function InvokeRewriteVersion
{
    param(
        [string]$destVersion
    )
    
    RewriteVersion `
        ([IO.Path]::Combine($scriptDirectoryPath, "NintendoSdkVsExtension.UnitTest.InIDE\NintendoSdkVsExtension.UnitTest.InIDE.15.csproj")) `
        ([IO.Path]::Combine($scriptDirectoryPath, "NintendoSdkVsExtension.UnitTest.InIDE\NintendoSdkVsExtension.UnitTest.InIDE.${destVersion}.csproj")) `
        $destVersion
}

InvokeRewriteVersion "14"
