﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.Shell.Interop;
using Microsoft.VSSDK.Tools.VsIdeTesting;
using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.NintendoSdkVsExtension.UnitTest
{
    /// <summary>
    /// VS IDE 内でのテストを行う際のユーティリティ
    /// </summary>
    internal static class VsTestUtil
    {
        public static void InvokeInUIThread(Action a)
        {
            UIThreadInvoker.Invoke(a);
        }

        public static void EnsureOpenSolution(string solutionFile)
        {
            if (Shell.VsSolutionUtil.IsSolutionOpen(VsIdeTestHostContext.ServiceProvider))
            {
                var solutioninfo = Shell.VsSolutionUtil.GetSolutionInfo(VsIdeTestHostContext.ServiceProvider);
                if (solutioninfo.SolutionFile == solutionFile)
                {
                    return;
                }

                ForceCloseSolution();
            }

            Shell.VsSolutionUtil.OpenSolution(VsIdeTestHostContext.ServiceProvider, solutionFile);
            Shell.VsSolutionUtil.EnsureSolutionIsLoaded(VsIdeTestHostContext.ServiceProvider);
        }

        public static void ForceCloseSolution()
        {
            if (Shell.VsSolutionUtil.IsSolutionOpen(VsIdeTestHostContext.ServiceProvider))
            {
                Shell.VsSolutionUtil.CloseSolution(VsIdeTestHostContext.ServiceProvider, __VSSLNSAVEOPTIONS.SLNSAVEOPT_NoSave);
            }
        }

        public static IVsHierarchy GetHierarchyOfName(string projectRelativePath)
        {
            return Shell.VsSolutionUtil.GetProjectOfUniqueName(VsIdeTestHostContext.ServiceProvider, projectRelativePath);
        }

        public static VcAccessors.VcProjectAccessor GetVcProjectOfName(string projectRelativePath)
        {
            return new VcAccessors.VcProjectAccessor(GetHierarchyOfName(projectRelativePath));
        }

        public static IEnumerable<ConfigurationPair> EnumerateProjectConfigurationFromXml(XElement root)
        {
            return root
                .Descendants(root.Name.Namespace + "ProjectConfiguration")
                .Select(x => new ConfigurationPair(x.Attribute("Include").Value))
                .ToArray();
        }
    }
}
