﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Common.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_Mutex.h>

class Hash
{
    NN_DISALLOW_COPY(Hash);

public:
    static const size_t Sha1MaxStrSize = 40;

public:
    NN_IMPLICIT Hash(const char* inFilePath) NN_NOEXCEPT;
    virtual ~Hash() NN_NOEXCEPT;

    int GetSha1(char* pOutStr, size_t inGetStrSize) NN_NOEXCEPT;

public:
    // 非同期用メソッド
    int StartSha1ProcessAsync() NN_NOEXCEPT;
    void StopSha1ProcessAsync() NN_NOEXCEPT;
    bool IsProcessing() NN_NOEXCEPT;
    int GetProgressPercent() NN_NOEXCEPT;
    int GetSha1Data(char* pOutStr, size_t inGetStrSize) NN_NOEXCEPT;

    int StartSha1ProcessAocAsync(const std::string& inMountName, int inIndex) NN_NOEXCEPT;

private:
    void* AllocateWorkHeap(size_t inHeapSize) NN_NOEXCEPT;
    void FreeWorkHeap(void* inPtr) NN_NOEXCEPT;

private:
    const char* m_FilePath;

private:
    // 非同期用内部メソッド、データ定義
    static void ProcessGetSha1Static(void* inPtr) NN_NOEXCEPT;
    void ProcessGetSha1() NN_NOEXCEPT;

    bool m_IsProcessing;
    bool m_IsStop;
    bool m_IsHashGetSuccess;
    char m_Sha1Data[Sha1MaxStrSize + 1];
    int m_ProgressPercent;

    bool m_IsAocFileAccess;
    std::string m_AocMountName;
    int m_AocIndex;

    nn::os::ThreadType m_Thread;
    nn::os::Mutex m_Mutex;
};

