﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TestAppSimple_EcServiceSceneCommon.h"

class EcOcsiScene : public EcServiceSceneCommon
{
    NN_DISALLOW_COPY(EcOcsiScene);

public:
    EcOcsiScene() NN_NOEXCEPT;
    virtual ~EcOcsiScene() NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;
    virtual void UpdateContents() NN_NOEXCEPT NN_OVERRIDE;

private:
    // 状態
    enum State
    {
        State_None,
        State_SelectUser,
        State_InquireRights,
        State_ConsumeRights,
        State_PurchaseRights,
        State_CheckRight,
        State_ShowError,
    };

    State m_State;
    int m_PageCount;
    int m_PageIndex;
    int m_LineCount;
    int m_LineIndex;

    Label m_UpdateLable;
    Label m_CosumeLable;
    Label m_PrevPageLabel;
    Label m_NextPageLabel;

    void MovePageRight() NN_NOEXCEPT;
    void MovePageLeft() NN_NOEXCEPT;
    void MoveLineDown() NN_NOEXCEPT;
    void MoveLineUp() NN_NOEXCEPT;

    int GetRightIndex() const NN_NOEXCEPT;
};
