﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TestAppSimple_EcServiceSceneCommon.h"

class EcCatalogScene : public EcServiceSceneCommon
{
    NN_DISALLOW_COPY(EcCatalogScene);

public:
    EcCatalogScene() NN_NOEXCEPT;
    virtual ~EcCatalogScene() NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;
    virtual void UpdateContents() NN_NOEXCEPT NN_OVERRIDE;

private:
    // 状態
    enum State
    {
        State_None,
        State_SelectUser,
        State_Inquire,
        State_MoveList,
        State_MoveItem,
        State_ShowShop,
        State_ShowError,
    };
    // モード
    enum Mode
    {
        Mode_List,
        Mode_Item,
    };

    State m_State;
    Mode m_Mode;
    int m_PageCount;
    int m_PageIndex;

    Label m_UpdateLable;
    Label m_PrevPageLabel;
    Label m_NextPageLabel;

    void DrawCatalogCommon(Position* line, nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void DrawCatalogList(Position* line, nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void DrawCatalogItem(Position* line, nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;

    void InquireCatalog() NN_NOEXCEPT;

    void MoveCatalogList() NN_NOEXCEPT;
    void MoveCatalogItem() NN_NOEXCEPT;
    void MovePageRight() NN_NOEXCEPT;
    void MovePageLeft() NN_NOEXCEPT;
};
