﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <map>
#include <nn/nn_Assert.h>

#include "TestAppSimple_DotText.h"

namespace {
    const int FontWidth = 6;
    const int FontHeight = 10;
    const int FontScale = 4;

    const struct FontPair
    {
        const char Character;
        const uint8_t FontData[FontHeight * FontWidth];
    } FontArray[] = {
        { '0',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,1,1,0,
            1,0,1,0,1,0,
            1,1,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { '1',{
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,1,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,1,1,0,0,
        }, },
        { '2',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            0,0,0,0,1,0,
            0,0,0,1,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
            1,1,1,1,1,0,
        }, },
        { '3',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            0,0,0,1,0,0,
            0,0,1,0,0,0,
            0,0,0,1,0,0,
            0,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { '4',{
            0,0,0,0,0,0,
            0,0,0,1,0,0,
            0,0,1,1,0,0,
            0,1,0,1,0,0,
            1,0,0,1,0,0,
            1,1,1,1,1,0,
            0,0,0,1,0,0,
            0,0,0,1,0,0,
        }, },
        { '5',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            1,0,0,0,0,0,
            1,1,1,1,0,0,
            0,0,0,0,1,0,
            0,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { '6',{
            0,0,0,0,0,0,
            0,0,1,1,0,0,
            0,1,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { '7',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            0,0,0,0,1,0,
            0,0,0,1,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
            0,1,0,0,0,0,
            0,1,0,0,0,0,
        }, },
        { '8',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { '9',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,1,0,
            0,0,0,0,1,0,
            0,0,0,1,0,0,
            0,1,1,0,0,0,
        }, },
        { 'a',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            0,0,0,0,1,0,
            0,1,1,1,1,0,
            1,0,0,0,1,0,
            0,1,1,1,1,0,
        }, },
        { 'b',{
            0,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,0,0,
        }, },
        { 'c',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,1,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            0,1,1,1,1,0,
        }, },
        { 'd',{
            0,0,0,0,0,0,
            0,0,0,0,1,0,
            0,0,0,0,1,0,
            0,1,1,1,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,1,0,
        }, },
        { 'e',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,1,1,1,1,0,
            1,0,0,0,0,0,
            0,1,1,1,0,0,
        }, },
        { 'f',{
            0,0,0,0,0,0,
            0,0,1,1,0,0,
            0,0,1,0,0,0,
            0,1,1,1,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,1,1,0,0,
        }, },
        { 'g',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,1,0,
            0,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'h',{
            0,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
        }, },
        { 'i',{
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,0,0,0,0,0,
            0,1,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,1,1,0,0,
        }, },
        { 'j',{
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
        }, },
        { 'k',{
            0,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,1,0,0,
            1,1,1,0,0,0,
            1,0,0,1,0,0,
            1,0,0,0,1,0,
        }, },
        { 'l',{
            0,0,0,0,0,0,
            0,1,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,1,1,0,0,
        }, },
        { 'm',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,1,0,1,0,
            1,0,1,0,1,0,
            1,0,1,0,1,0,
            1,0,1,0,1,0,
        }, },
        { 'n',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
        }, },
        { 'o',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'p',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
        }, },
        { 'q',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,1,0,
            0,0,0,0,1,0,
            0,0,0,0,1,0,
        }, },
        { 'r',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,0,1,1,0,0,
            1,1,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
        }, },
        { 's',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,1,1,1,1,0,
            1,0,0,0,0,0,
            0,1,1,1,0,0,
            0,0,0,0,1,0,
            1,1,1,1,0,0,
        }, },
        { 't',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,1,1,1,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,0,1,0,0,
        }, },
        { 'u',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,1,1,0,
            0,1,1,0,1,0,
        }, },
        { 'v',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,0,1,0,0,
            0,0,1,0,0,0,
        }, },
        { 'w',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,1,0,1,0,
            1,0,1,0,1,0,
            0,1,1,1,0,0,
            0,1,0,1,0,0,
        }, },
        { 'x',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            0,1,0,1,0,0,
            0,0,1,0,0,0,
            0,1,0,1,0,0,
            1,0,0,0,1,0,
        }, },
        { 'y',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,1,0,
            0,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'z',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            0,0,0,1,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
            1,1,1,1,1,0,
        }, },
        { 'A',{
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,1,0,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
        }, },
        { 'B',{
            0,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,0,0,
        }, },
        { 'C',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'D',{
            0,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,0,0,
        }, },
        { 'E',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,1,0,
        }, },
        { 'F',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
        }, },
        { 'G',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,0,0,
            1,0,1,1,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'H',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
        }, },
        { 'I',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,1,1,0,0,
        }, },
        { 'J',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            0,0,0,0,1,0,
            0,0,0,0,1,0,
            0,0,0,0,1,0,
            0,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'K',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,1,0,0,
            1,0,1,0,0,0,
            1,1,0,0,0,0,
            1,0,1,0,0,0,
            1,0,0,1,0,0,
            1,0,0,0,1,0,
        }, },
        { 'L',{
            0,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,1,0,
        }, },
        { 'M',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,1,0,1,1,0,
            1,0,1,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
        }, },
        { 'N',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,0,0,1,0,
            1,0,1,0,1,0,
            1,0,0,1,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
        }, },
        { 'O',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'P',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
            1,0,0,0,0,0,
        }, },
        { 'Q',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,1,0,1,0,
            1,0,0,1,1,0,
            0,1,1,1,0,0,
        }, },
        { 'R',{
            0,0,0,0,0,0,
            1,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,1,1,1,0,0,
            1,0,1,0,0,0,
            1,0,0,1,0,0,
            1,0,0,0,1,0,
        }, },
        { 'S',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            1,0,0,0,0,0,
            0,1,1,1,0,0,
            0,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'T',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
        }, },
        { 'U',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,1,1,0,0,
        }, },
        { 'V',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,0,1,0,0,
            0,0,1,0,0,0,
        }, },
        { 'W',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            1,0,1,0,1,0,
            1,0,1,0,1,0,
            1,0,1,0,1,0,
            0,1,0,1,0,0,
            0,1,0,1,0,0,
        }, },
        { 'X',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            0,1,0,1,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,0,1,0,0,
            1,0,0,0,1,0,
        }, },
        { 'Y',{
            0,0,0,0,0,0,
            1,0,0,0,1,0,
            1,0,0,0,1,0,
            0,1,0,1,0,0,
            0,1,0,1,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
        }, },
        { 'Z',{
            0,0,0,0,0,0,
            1,1,1,1,1,0,
            0,0,0,0,1,0,
            0,0,0,1,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
            1,0,0,0,0,0,
            1,1,1,1,1,0,
        }, },
        { '/',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,1,0,
            0,0,0,1,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
            1,0,0,0,0,0,
            0,0,0,0,0,0,
        }, },
        { ':',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,0,0,0,0,0,
        }, },
        { ';',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
        }, },
        { '(',{
            0,0,0,0,0,0,
            0,0,0,1,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,0,1,0,0,
        }, },
        { ')',{
            0,0,0,0,0,0,
            0,1,0,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,0,1,0,0,0,
            0,1,0,0,0,0,
        }, },
        { '?',{
            0,0,0,0,0,0,
            0,1,1,1,0,0,
            1,0,0,0,1,0,
            0,0,0,0,1,0,
            0,0,1,1,0,0,
            0,0,1,0,0,0,
            0,0,0,0,0,0,
            0,0,1,0,0,0,
        }, },
        { ' ',{
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
            0,0,0,0,0,0,
        }, },
    };

    std::map<char, const uint8_t*> g_FontMap;
    void InitializeFontData() NN_NOEXCEPT
    {
        for (auto& fontStructPair : FontArray)
        {
            g_FontMap[fontStructPair.Character] = fontStructPair.FontData;
        }
    }

    const uint8_t* GetDotArray(char character) NN_NOEXCEPT
    {
        auto iter = g_FontMap.find(character);
        if (iter != g_FontMap.end())
        {
            return iter->second;
        }
        return g_FontMap['?'];
    }
}

void DrawText(uint8_t* pImage, int imageWidth, int imageHeight, int pixelSize, const std::string& text, int textPosX, int textPosY) NN_NOEXCEPT
{
    if (g_FontMap.size() == 0)
    {
        InitializeFontData();
    }

    for (size_t i = 0; i < text.size(); i++)
    {
        auto dotArray = GetDotArray(text[i]);
        auto charPosX = textPosX + FontWidth * static_cast<int>(i) * FontScale;
        auto charPosY = textPosY;

        for (int y = 0; y < FontHeight * FontScale; y++)
        {
            auto dotPosY = charPosY + y;
            if (dotPosY < 0 || dotPosY >= imageHeight)
            {
                continue;
            }

            auto pLine = pImage + pixelSize * imageWidth * dotPosY;
            for (int x = 0; x < FontWidth * FontScale; x++)
            {
                auto dotPosX = charPosX + x;
                if (dotPosX < 0 || dotPosX >= imageWidth)
                {
                    continue;
                }

                if (dotArray[(y / FontScale) * FontWidth + (x / FontScale)] == 1)
                {
                    auto pPixel = pLine + pixelSize * dotPosX;
                    pPixel[0] = 255; // R
                    pPixel[1] = 255; // G
                    pPixel[2] = 255; // B
                    pPixel[3] = 255; // A （無視される）
                }
            }
        }
    }
}
