﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PropertySheetsTest
{
    public class VcProject
    {
        private Dictionary<ConfigurationPair, EvaluatedVcProject> projects;

        public VcProject(
            string path,
            string vsVersion,
            IDictionary<string, string> globalProperteis = null)
        {
            projects = Util.ReadConfigurationPairsFromVcProject(path)
                .ToDictionary(p => p, p => new EvaluatedVcProject(path, p, vsVersion, globalProperteis));
        }

        public EvaluatedVcProject this[ConfigurationPair key]
        {
            get { return projects[key]; }
        }
    }
}
