﻿using System;
using System.Text.RegularExpressions;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkVersion : PropertySheetsTest
    {
        // 何らかの数値が取得できれば OK とする
        private static readonly Regex s_NumberPattern = new Regex(@"^\d+$", RegexOptions.Compiled);

        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care
                    break;
                case "Samples":
                case "Users":
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkVersionMajor"]));
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkVersionMinor"]));
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkVersionMicro"]));
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkVersionReleaseStep"]));
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }
    }
}
