﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkProgramCategory : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.ProjectType == ProjectType.Library || conf.ProjectType == ProjectType.DynamicLibrary)
            {
                // $(NintendoSdkProgramCategory) はライブラリのビルドでは使用しない
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                        case ProjectType.DynamicLibrary:
                            // don't care
                            break;
                        case ProjectType.Program:
                        case ProjectType.ProgramWithoutSdkNso:
                            Assert.Equal("TargetTools", ep.Properties["NintendoSdkProgramCategory"]);
                            break;
                        case ProjectType.SystemProgram:
                            Assert.Equal("Processes", ep.Properties["NintendoSdkProgramCategory"]);
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                case "Samples":
                case "Tests":
                case "Users":
                    // don't care
                    break;
                default:
                    Assert.True(false, string.Format("{0}: 未知の SubRootName です。", conf.SubRootName));
                    break;
            }
        }
    }
}
