﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkGenerateDebugInformation : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.PlatformToolset)
            {
                case "v120":
                case "v140":
                    Assert.Equal("true", ep.Metadata["Link.GenerateDebugInformation"]);
                    break;
                case "v141":
                    // https://docs.microsoft.com/en-us/cpp/build/reference/debug-generate-debug-info
                    // v141 からは、 GenerateDebugInformation=true の場合のオプションが /DBUG:FASTLINK に変更された。
                    // /DEBUG:FULL を明示する。
                    Assert.Equal("DebugFull", ep.Metadata["Link.GenerateDebugInformation"]);
                    break;
                default:
                    throw new ArgumentException($"不明な PlatformToolset です: {conf.PlatformToolset}", nameof(conf.PlatformToolset));
            }
        }
    }
}
