﻿using System;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkEnableDeadStrip : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                    // don't care
                    break;
                case ProjectType.Program:
                    switch (conf.SubRootName)
                    {
                        case "Alice":
                        case "Chris":
                        case "Eris":
                        case "Iris":
                        case "NintendoWare":
                        case "Samples":
                        case "Tests":
                            Assert.Equal("false", ep.Metadata["Link.EnableDeadStrip"]);
                            break;
                        case "Users":
                            Assert.Equal("true", ep.Metadata["Link.EnableDeadStrip"]);
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                            break;
                    }
                    break;
                case ProjectType.DynamicLibrary:
                case ProjectType.ProgramWithoutSdkNso:
                case ProjectType.SystemProgram:
                    Assert.Equal("false", ep.Metadata["Link.EnableDeadStrip"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の ProjectType です: {0}", conf.ProjectType));
                    break;
            }
        }
    }
}
