﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_Log.h>
#include <nnt.h>

#include <limits>
#include <random>

#if defined(__ARM_NEON__) || defined(__ARM_NEON)
namespace generic {

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/detail/audio_Resample.generic.h"

}  // namespace negeric

namespace neon {

#include "../../Programs/Eris/Sources/Libraries/audio/dsp/detail/audio_Resample.neon.h"

}  // namespace neon

TEST(DspResample, CompareGenericAndNeon)
{
    const int InputSampleCount = 16384;
    const int OutputSampleCount = 240;
    int32_t input[InputSampleCount];
    std::mt19937 mt(0);
    for (auto i = 0; i < InputSampleCount; ++i)
    {
        const auto a = std::numeric_limits<uint16_t>::max();
        const auto b = std::numeric_limits<int16_t>::min();
        input[i] = (mt() % a) + b;
    }
    const int32_t startPitch[] = {(1 << 15), (1 << 15) * 4 / 3, ((1 << 15) * 4 / 3) + 1};
    const int32_t startFraction[] = { 0, 100, 4096};
    for (const auto pitch : startPitch)
    {
        for (const auto fraction : startFraction)
        {
            int32_t fraction0 = fraction;
            int32_t fraction1 = fraction;
            int32_t output0[OutputSampleCount] = {0};
            int32_t output1[OutputSampleCount] = {0};

            generic::nn::audio::dsp::detail::ResampleImpl(output0, input, pitch, &fraction0, OutputSampleCount);
            neon::nn::audio::dsp::detail::ResampleImpl(output1, input, pitch, &fraction1, OutputSampleCount);

            ASSERT_EQ(fraction0, fraction1);
            for (auto i = 0; i < OutputSampleCount; ++i)
            {
                ASSERT_EQ(output0[i], output1[i]) << "index: " << i;
            }
        }
    }
}

#endif  // defined(__ARM_NEON__) || defined(__ARM_NEON)
