﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/atk.h>

namespace nnt { namespace atk { namespace effectUtil {

const nn::atk::EffectBase::ChannelMode TestEffectChannelMode[] =
{
    nn::atk::EffectBase::ChannelMode_1Ch
    , nn::atk::EffectBase::ChannelMode_2Ch
    , nn::atk::EffectBase::ChannelMode_4Ch
    , nn::atk::EffectBase::ChannelMode_6Ch
};

const nn::atk::EffectBase::SampleRate TestEffectSampleRate[] =
{
    nn::atk::EffectBase::SampleRate_32000
    , nn::atk::EffectBase::SampleRate_48000
};

class EffectAuxTest : public nn::atk::EffectAux
{
public:
    virtual bool Initialize() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
protected:
    virtual void UpdateSamples(int32_t* pSamples, const UpdateSamplesArg& arg) NN_NOEXCEPT NN_OVERRIDE;
};

void UpdateAndProcess(nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT;
void WaitForEffectClear(nn::atk::EffectBase& effect) NN_NOEXCEPT;
void WaitForEffectClear(nn::atk::EffectAux& effect) NN_NOEXCEPT;
void WaitForEffectAppend(nn::atk::EffectBase& effect) NN_NOEXCEPT;
void WaitForEffectAppend(nn::atk::EffectAux& effect) NN_NOEXCEPT;
int ConvertChannelModeToInt(nn::atk::EffectBase::ChannelMode channelMode) NN_NOEXCEPT;
int ConvertSampleRateToInt(nn::atk::EffectBase::SampleRate sampleRate) NN_NOEXCEPT;

void AppendEffectAndWait(nn::atk::AuxBus bus, nn::atk::EffectBase* pEffect, void* buffer, size_t bufferSize, nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT;
void RemoveEffectAndWait(nn::atk::AuxBus bus, nn::atk::EffectBase* pEffect, nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT;

const auto WaitTime = nn::TimeSpan::FromMilliSeconds(16);
const auto TimeOut = nn::TimeSpan::FromMilliSeconds(5000);

}}}
