﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CsClient
{
    class ResponseUtils
    {
        private enum ResponseType
        {
            Response_Null,
            Response_Success,
            Response_Error,
            Response_ProgramExited,
            Response_FirmwareVersion,
            Response_JitDebug,
            Response_ProgramLaunched,
            Response_TitleName,
        }

        // レスポンスを受信して表示
        public static void Receive(BinaryReader reader)
        {
            // レスポンスヘッダ
            long id = reader.ReadInt64();
            int response = reader.ReadInt32();
            uint dataSize = reader.ReadUInt32();

            Console.WriteLine("id: {0}", id);
            Console.WriteLine("response: {0}", response);
            Console.WriteLine("dataSize: {0}", dataSize);

            // レスポンスボディ
            if (response == (int)ResponseType.Response_Error)
            {
                Console.WriteLine("result: 0x{0:x8}", reader.ReadUInt32());
                reader.ReadInt32();
            }
            if (response == (int)ResponseType.Response_ProgramExited)
            {
                Console.WriteLine(string.Format("processIndex: {0}", reader.ReadInt64()));
            }
            if (response == (int)ResponseType.Response_FirmwareVersion)
            {
                Console.Write("platform: ");
                Console.WriteLine(new string(reader.ReadChars(32)));
                Console.Write("revision: ");
                Console.WriteLine(new string(reader.ReadChars(64)));
                Console.Write("displayname: ");
                Console.WriteLine(new string(reader.ReadChars(128)));
            }
            if (response == (int)ResponseType.Response_ProgramLaunched)
            {
                Console.WriteLine(string.Format("processIndex: {0}", reader.ReadInt64()));
            }
            if (response == (int)ResponseType.Response_TitleName)
            {
                Int32 titleLength = reader.ReadInt32();
                Console.WriteLine(string.Format("titleLength: {0}", titleLength));
                Console.WriteLine(string.Format("title: {0}", System.Text.Encoding.UTF8.GetString(reader.ReadBytes(titleLength))));
            }
        }
    }
}
