﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace CsClient
{
    internal class CsClientParams
    {
        [CommandLineOption("command",
            IsRequired = true,
            Description = "Option_CommandValue",
            ValueName = "Integer")]
        public int Command { get; set; }

        [CommandLineOption("path",
            IsRequired = false,
            Description = "Option_ExecutableFilePath",
            ValueName = "Path")]
        public string Path { get; set; }

        [CommandLineOption("argument",
            IsRequired = false,
            Description = "Option_CommandLineArguments",
            ValueName = "String")]
        public string Argument { get; set; }

        [CommandLineOption("env_path",
            IsRequired = false,
            Description = "Option_TargetEnvironmentVariableFilePath",
            ValueName = "Path")]
        public string EnvPath { get; set; }

        [CommandLineOption("flag",
            IsRequired = false,
            Description = "Option_Flag")]
        public bool Flag { get; set; }

        [CommandLineOption("index",
            IsRequired = false,
            Description = "Option_ProcessIndex")]
        public ulong Index { get; set; }

        [CommandLineOption("int-param",
            Description = "Option_IntParameter")]
        public int IntParam { get; set; }

        [CommandLineOption("receive-loop",
            Description = "Loop infinitely after sending command.")]
        public bool loop { get; set; }
    }
}
