﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CsClient
{
    class CommandUtils
    {
        private const ulong DummyProgramId = 0x0005000C10000000;

        private enum Command
        {
            Command_Null,
            Command_LaunchProcess,
            Command_TerminateProcess,
            Command_GetFirmwareVersion,
            Command_Reboot,
            Command_SetSafeMode,
            Command_RegisterTenvDefinitionFilePath,
            Command_TerminateApplication,
            Command_Shutdown,
            Command_SubscribeProcessEvent,
            Command_GetTitleName,
            Command_ControlVirtualTemperature,
        }

        private static void LaunchProcess(BinaryWriter writer, string path, string argument, string envPath)
        {
            // argument が null なら空文字列として扱う
            // argv[0] は実行ファイルのパス
            if (argument == null)
            {
                argument = path + " ";
            }
            else
            {
                argument = path + " " + argument;
            }

            // envPath が null なら空文字列を使う
            if (envPath == null)
            {
                envPath = "";
            }

            var bodySize = 24 + path.Length + argument.Length + envPath.Length;

            Console.WriteLine("LaunchProcess");
            Console.WriteLine("path: " + path);
            Console.WriteLine("argument: " + argument);
            Console.WriteLine("envPath: " + envPath);

            // コマンドヘッダ送信
            writer.Write((long)0); // ID
            writer.Write((int)1); // コマンド
            writer.Write((uint)bodySize); // コマンドボディのサイズ

            // コマンドボディ送信
            writer.Write((ulong)DummyProgramId); // ProgramID
            writer.Write((uint)path.Length);
            writer.Write((uint)argument.Length);
            writer.Write((uint)0); // flags
            writer.Write((uint)envPath.Length);
            writer.Write(System.Text.Encoding.ASCII.GetBytes(path));
            writer.Write(System.Text.Encoding.ASCII.GetBytes(argument));
            writer.Write(System.Text.Encoding.ASCII.GetBytes(envPath));
            writer.Flush();
        }

        private static void TerminateProcess(BinaryWriter writer)
        {
            Console.WriteLine("TerminateProcess");

            // コマンドヘッダ送信
            writer.Write((ulong)0); // ID
            writer.Write((uint)2); // コマンド
            writer.Write((uint)0); // コマンドボディのサイズ
        }

        private static void GetFirmwareVersion(BinaryWriter writer)
        {
            Console.WriteLine("GetFirmwareVersion");

            // コマンド送信
            writer.Write((long)0); // ID
            writer.Write((int)3); // コマンド
            writer.Write((uint)0); // コマンドボディのサイズ
            writer.Flush();
        }

        private static void TerminateApplication(BinaryWriter writer)
        {
            Console.WriteLine("TerminateApplication");

            // コマンドヘッダ送信
            writer.Write((ulong)0); // ID
            writer.Write((uint)7); // コマンド
            writer.Write((uint)0); // コマンドボディのサイズ
        }

        private static void SubscribeProcessEvent(BinaryWriter writer, bool flag)
        {
            Console.WriteLine("SubscribeProcessEvent");

            // コマンドヘッダ送信
            writer.Write((ulong)0); // ID
            writer.Write((uint)Command.Command_SubscribeProcessEvent);
            writer.Write((uint)4);

            // コマンドボディ送信
            writer.Write(flag);
            writer.Write((byte)0);
            writer.Write((byte)0);
            writer.Write((byte)0);
        }

        private static void GetTitleName(BinaryWriter writer, ulong index)
        {
            Console.WriteLine("GetTitleName");

            // コマンドヘッダ送信
            writer.Write((ulong)0); // ID
            writer.Write((uint)Command.Command_GetTitleName);
            writer.Write((uint)8);

            // コマンドボディ送信
            writer.Write(index);
        }

        private static void ControlVirtualTemperature(BinaryWriter writer, bool isEnable, int temperature)
        {
            Console.WriteLine("ControlVirtuallTemperature : " + temperature);

            // コマンドヘッダ送信
            writer.Write((ulong)0); // ID
            writer.Write((uint)Command.Command_ControlVirtualTemperature);
            writer.Write((uint)8);

            // コマンドボディ送信
            writer.Write(isEnable);
            writer.Write((byte)0);
            writer.Write((byte)0);
            writer.Write((byte)0);
            writer.Write(temperature);
        }

        public static void Send(BinaryWriter writer, CsClientParams param)
        {
            switch ((Command)param.Command)
            {
                case Command.Command_LaunchProcess:
                    LaunchProcess(writer, param.Path, param.Argument, param.EnvPath);
                    break;
                case Command.Command_TerminateProcess:
                    TerminateProcess(writer);
                    break;
                case Command.Command_GetFirmwareVersion:
                    GetFirmwareVersion(writer);
                    break;
                case Command.Command_TerminateApplication:
                    TerminateApplication(writer);
                    break;
                case Command.Command_SubscribeProcessEvent:
                    SubscribeProcessEvent(writer, param.Flag);
                    break;
                case Command.Command_GetTitleName:
                    GetTitleName(writer, param.Index);
                    break;
                case Command.Command_ControlVirtualTemperature:
                    ControlVirtualTemperature(writer, param.Flag, param.IntParam);
                    break;
                default:
                    Console.WriteLine("Command {0} is not implemented.", param.Command);
                    break;
            }
        }
    }
}
