﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_ServiceDiscovery.h>
#include <nnt/nntest.h>

//!< ServiceDiscoveryControlSettings を取得可能か
TEST(ServiceDiscovery, ServiceDiscoveryControlSettings1)
{
    ::nn::settings::system::ServiceDiscoveryControlSettings value = {};
    ::nn::settings::system::GetServiceDiscoveryControlSettings(&value);
}

//!< ServiceDiscoveryControlSettings を設定可能か
TEST(ServiceDiscovery, ServiceDiscoveryControlSettings2)
{
    ::nn::settings::system::ServiceDiscoveryControlSettings backup = {};
    ::nn::settings::system::GetServiceDiscoveryControlSettings(&backup);

    ::nn::settings::system::ServiceDiscoveryControlSettings value = {};

    value.flag.Reset();
    SetServiceDiscoveryControlSettings(value);
    {
        ::nn::settings::system::ServiceDiscoveryControlSettings outValue = {};
        ::nn::settings::system::GetServiceDiscoveryControlSettings(&outValue);
        EXPECT_FALSE(outValue.flag.Test<::nn::settings::system::ServiceDiscoveryControlFlag::IsChangeEnvironmentIdentifierDisabled>());
    }

    value.flag.Set<::nn::settings::system::ServiceDiscoveryControlFlag::IsChangeEnvironmentIdentifierDisabled>();
    SetServiceDiscoveryControlSettings(value);
    {
        ::nn::settings::system::ServiceDiscoveryControlSettings outValue = {};
        ::nn::settings::system::GetServiceDiscoveryControlSettings(&outValue);
        EXPECT_TRUE(outValue.flag.Test<::nn::settings::system::ServiceDiscoveryControlFlag::IsChangeEnvironmentIdentifierDisabled>());
    }

    SetServiceDiscoveryControlSettings(backup);
}

