﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_Ptm.h>
#include <nnt/nntest.h>

namespace {

//!< PTM の電池残量パラメータ A
const ::nn::settings::system::PtmFuelGaugeParameter PtmFuelGaugeParameterA =
{
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
};

//!< PTM の電池残量パラメータ B
const ::nn::settings::system::PtmFuelGaugeParameter PtmFuelGaugeParameterB =
{
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
};

} // namespace

//!< PTM の電池 LOT を取得可能か
TEST(PtmSuite, PtmBatteryLotTest1)
{
    ::nn::settings::system::PtmBatteryLot ptmBatteryLot = {};

    ::nn::settings::system::GetPtmBatteryLot(&ptmBatteryLot);
}

//!< PTM の電池 LOT を変更可能か
TEST(PtmSuite, PtmBatteryLotTest2)
{
    ::nn::settings::system::PtmBatteryLot ptmBatteryLot = {};

    ::nn::settings::system::GetPtmBatteryLot(&ptmBatteryLot);

    const ::nn::settings::system::PtmBatteryLot PtmBatteryLotA = { "foobar" };

    ::nn::settings::system::SetPtmBatteryLot(PtmBatteryLotA);

    ::nn::settings::system::PtmBatteryLot ptmBatteryLotA = {};

    ::nn::settings::system::GetPtmBatteryLot(&ptmBatteryLotA);

    EXPECT_STREQ(PtmBatteryLotA.string, ptmBatteryLotA.string);

    const ::nn::settings::system::PtmBatteryLot PtmBatteryLotB = { "hoge" };

    ::nn::settings::system::SetPtmBatteryLot(PtmBatteryLotB);

    ::nn::settings::system::PtmBatteryLot ptmBatteryLotB = {};

    ::nn::settings::system::GetPtmBatteryLot(&ptmBatteryLotB);

    EXPECT_STREQ(PtmBatteryLotB.string, ptmBatteryLotB.string);

    ::nn::settings::system::SetPtmBatteryLot(ptmBatteryLot);
}

//!< PTM の電池残量パラメータを取得可能か
TEST(PtmSuite, PtmFuelGaugeParameterTest1)
{
    ::nn::settings::system::PtmFuelGaugeParameter ptmFuelGaugeParameter = {};

    ::nn::settings::system::GetPtmFuelGaugeParameter(&ptmFuelGaugeParameter);
}

//!< PTM の電池残量パラメータを変更可能か
TEST(PtmSuite, PtmFuelGaugeParameterTest2)
{
    ::nn::settings::system::PtmFuelGaugeParameter ptmFuelGaugeParameter = {};

    ::nn::settings::system::GetPtmFuelGaugeParameter(&ptmFuelGaugeParameter);

    ::nn::settings::system::SetPtmFuelGaugeParameter(PtmFuelGaugeParameterA);

    ::nn::settings::system::PtmFuelGaugeParameter ptmFuelGaugeParameterA = {};

    ::nn::settings::system::GetPtmFuelGaugeParameter(&ptmFuelGaugeParameterA);

    EXPECT_EQ(PtmFuelGaugeParameterA.rcomp0,
              ptmFuelGaugeParameterA.rcomp0);

    EXPECT_EQ(PtmFuelGaugeParameterA.tempCo,
              ptmFuelGaugeParameterA.tempCo);

    EXPECT_EQ(PtmFuelGaugeParameterA.fullCap,
              ptmFuelGaugeParameterA.fullCap);

    EXPECT_EQ(PtmFuelGaugeParameterA.fullCapNom,
              ptmFuelGaugeParameterA.fullCapNom);

    EXPECT_EQ(PtmFuelGaugeParameterA.iavg_empty,
              ptmFuelGaugeParameterA.iavg_empty);

    EXPECT_EQ(PtmFuelGaugeParameterA.qrTable00,
              ptmFuelGaugeParameterA.qrTable00);

    EXPECT_EQ(PtmFuelGaugeParameterA.qrTable10,
              ptmFuelGaugeParameterA.qrTable10);

    EXPECT_EQ(PtmFuelGaugeParameterA.qrTable20,
              ptmFuelGaugeParameterA.qrTable20);

    EXPECT_EQ(PtmFuelGaugeParameterA.qrTable30,
              ptmFuelGaugeParameterA.qrTable30);

    EXPECT_EQ(PtmFuelGaugeParameterA.cycles,
              ptmFuelGaugeParameterA.cycles);

    ::nn::settings::system::SetPtmFuelGaugeParameter(PtmFuelGaugeParameterB);

    ::nn::settings::system::PtmFuelGaugeParameter ptmFuelGaugeParameterB = {};

    ::nn::settings::system::GetPtmFuelGaugeParameter(&ptmFuelGaugeParameterB);

    EXPECT_EQ(PtmFuelGaugeParameterB.rcomp0,
              ptmFuelGaugeParameterB.rcomp0);

    EXPECT_EQ(PtmFuelGaugeParameterB.tempCo,
              ptmFuelGaugeParameterB.tempCo);

    EXPECT_EQ(PtmFuelGaugeParameterB.fullCap,
              ptmFuelGaugeParameterB.fullCap);

    EXPECT_EQ(PtmFuelGaugeParameterB.fullCapNom,
              ptmFuelGaugeParameterB.fullCapNom);

    EXPECT_EQ(PtmFuelGaugeParameterB.iavg_empty,
              ptmFuelGaugeParameterB.iavg_empty);

    EXPECT_EQ(PtmFuelGaugeParameterB.qrTable00,
              ptmFuelGaugeParameterB.qrTable00);

    EXPECT_EQ(PtmFuelGaugeParameterB.qrTable10,
              ptmFuelGaugeParameterB.qrTable10);

    EXPECT_EQ(PtmFuelGaugeParameterB.qrTable20,
              ptmFuelGaugeParameterB.qrTable20);

    EXPECT_EQ(PtmFuelGaugeParameterB.qrTable30,
              ptmFuelGaugeParameterB.qrTable30);

    EXPECT_EQ(PtmFuelGaugeParameterB.cycles,
              ptmFuelGaugeParameterB.cycles);

    ::nn::settings::system::SetPtmFuelGaugeParameter(ptmFuelGaugeParameter);
}
