﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_FirmwareVersion.h>
#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/util/util_FormatString.h>
#include <nnt/nntest.h>

//!< ファームウェアバージョンを取得可能か
TEST(FirmwareVersionSuite, FirmwareVersionTest1)
{
    ::nn::settings::system::FirmwareVersion value = {};

    ::nn::settings::system::GetFirmwareVersion(&value);

    EXPECT_EQ(NN_FIRMWARE_VERSION_MAJOR, value.major);

    EXPECT_EQ(NN_FIRMWARE_VERSION_MINOR, value.minor);

    EXPECT_EQ(NN_FIRMWARE_VERSION_MICRO, value.micro);

    EXPECT_EQ(NN_FIRMWARE_VERSION_MAJORRELSTEP, value.majorRelstep);

    EXPECT_EQ(NN_FIRMWARE_VERSION_MINORRELSTEP, value.minorRelstep);

    char platform[32] = {
#ifdef NN_BUILD_CONFIG_SPEC_GENERIC
        "Generic"
#elif NN_BUILD_CONFIG_SPEC_NX
        "NX"
#else
        "Unknown"
#endif
    };

    EXPECT_STREQ(platform, value.platform);

    char displayVersion[24] = {};

    ::nn::util::SNPrintf(displayVersion, sizeof(displayVersion),
                         "%d.%d.%d",
                         NN_FIRMWARE_VERSION_MAJOR,
                         NN_FIRMWARE_VERSION_MINOR,
                         NN_FIRMWARE_VERSION_MICRO);

    EXPECT_STREQ(displayVersion, value.displayVersion);
}

//!< ファームウェアバージョンを比較可能か
TEST(FirmwareVersionSuite, FirmwareVersionTest2)
{
    ::nn::settings::system::FirmwareVersion v000 = { 0, 0, 0 };
    ::nn::settings::system::FirmwareVersion v001 = { 0, 0, 1 };
    ::nn::settings::system::FirmwareVersion v010 = { 0, 1, 0 };
    ::nn::settings::system::FirmwareVersion v100 = { 1, 0, 0 };

    EXPECT_TRUE(v001 == v001);
    EXPECT_TRUE(v010 == v010);
    EXPECT_TRUE(v100 == v100);

    EXPECT_TRUE(v000 != v001);
    EXPECT_TRUE(v000 != v010);
    EXPECT_TRUE(v000 != v100);

    EXPECT_TRUE(v000 < v001);
    EXPECT_TRUE(v000 < v010);
    EXPECT_TRUE(v000 < v100);

    EXPECT_TRUE(v001 > v000);
    EXPECT_TRUE(v010 > v000);
    EXPECT_TRUE(v100 > v000);

    EXPECT_TRUE(v001 <= v001);
    EXPECT_TRUE(v010 <= v010);
    EXPECT_TRUE(v100 <= v100);

    EXPECT_TRUE(v000 <= v001);
    EXPECT_TRUE(v000 <= v010);
    EXPECT_TRUE(v000 <= v100);

    EXPECT_TRUE(v001 >= v001);
    EXPECT_TRUE(v010 >= v010);
    EXPECT_TRUE(v100 >= v100);

    EXPECT_TRUE(v001 >= v000);
    EXPECT_TRUE(v010 >= v000);
    EXPECT_TRUE(v100 >= v000);

    EXPECT_FALSE(v000 == v001);
    EXPECT_FALSE(v000 == v010);
    EXPECT_FALSE(v000 == v100);

    EXPECT_FALSE(v001 != v001);
    EXPECT_FALSE(v010 != v010);
    EXPECT_FALSE(v100 != v100);

    EXPECT_FALSE(v001 < v000);
    EXPECT_FALSE(v010 < v000);
    EXPECT_FALSE(v100 < v000);

    EXPECT_FALSE(v000 > v001);
    EXPECT_FALSE(v000 > v010);
    EXPECT_FALSE(v000 > v100);

    EXPECT_FALSE(v001 <= v000);
    EXPECT_FALSE(v010 <= v000);
    EXPECT_FALSE(v100 <= v000);

    EXPECT_FALSE(v000 >= v001);
    EXPECT_FALSE(v000 >= v010);
    EXPECT_FALSE(v000 >= v100);
}

//!< ファームウェアバージョンのダイジェストを取得可能か
TEST(FirmwareVersionSuite, FirmwareVersionDigestTest1)
{
    ::nn::settings::system::FirmwareVersionDigest value = {};

    ::nn::settings::system::GetFirmwareVersionDigest(&value);

    EXPECT_STREQ(NN_FIRMWARE_VERSION_DIGEST, value.data);
}

//!< 再起動不要 NUP のバージョンを取得可能か
TEST(RebootlessSystemUpdateVersionSuite, RebootlessSystemUpdateVersionTest1)
{
    ::nn::settings::system::RebootlessSystemUpdateVersion value = {};

    ::nn::settings::system::GetRebootlessSystemUpdateVersion(&value);

    // 運用上表示バージョンが空文字列でないことは保証されている
    EXPECT_STRNE("", value.displayVersion);
}
