﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/spl/spl_Api.h>
#include <nnt/nntest.h>

//!< HardwareType に応じたプラットフォーム構成情報を取得できることをテストする
TEST(SettingsPfCfgSuite, PfCfgTest1)
{
    const char* const name = "platformconfig";
    const char* const key = "platformtype";

    // 設定項目は存在することが期待される
    size_t size = ::nn::settings::fwdbg::GetSettingsItemValueSize(name,
                                                                  key);
    EXPECT_NE(0, size);

    // 読み込んだ設定項目のサイズは取得したサイズと一致することが期待される
    char buffer[size];
    EXPECT_EQ(size,
              ::nn::settings::fwdbg::GetSettingsItemValue(buffer,
                                                          size,
                                                          name,
                                                          key));

    // spl で取得した HardwareType に応じた値が取得できることが期待される
    const char* expectValue;
    ::nn::spl::Initialize();
    switch(::nn::spl::GetHardwareType())
    {
        case ::nn::spl::HardwareType_Icosa:
            expectValue = "Icosa";
            break;
        case ::nn::spl::HardwareType_Iowa:
            expectValue = "IcosaMariko";
            break;
        case ::nn::spl::HardwareType_Copper:
            expectValue = "Copper";
            break;
        case ::nn::spl::HardwareType_Hoag:
            expectValue = "Hoag";
        default:
            NN_UNEXPECTED_DEFAULT;
    }
    ::nn::spl::Finalize();

    EXPECT_STREQ(expectValue, buffer);
}
