﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

typedef int8_t s8;
typedef int16_t s16;
typedef int32_t s32;
typedef int64_t s64;

#define U8SIZEOF(a)    (sizeof(a)/sizeof(u8))
#define U32SIZEOF(a)    (sizeof(a)/sizeof(u32))


typedef enum {
    StorageInterfaceType_NAND,
    StorageInterfaceType_SD,
    StorageInterfaceType_GC,
    sizeof_StorageInterfaceType
} StorageInterfaceType;


typedef enum
{
    Operation_None,
    Operation_Loop,
    Operation_LoopEnd,

    Operation_Power,
    Operation_Select,
    Operation_Init,
    Operation_Enable,
    Operation_Seed,
    Operation_Skip,
    Operation_Write,
    Operation_Read,
    Operation_WriteRead,
    Operation_SecureErase,
    Operation_Load,
    Operation_Dump,
    Operation_Insert,
    Operation_Wait,
    Operation_Pause,
    Operation_Register,
    Operation_MeasureBegin,
    Operation_MeasureEnd,
    Operation_Identify,
    Operation_Log,
    Operation_Erase,
    Operation_Speed,
    Operation_Partition,
    Operation_Reg,
    Operation_WriteParam,
    Operation_Command,
    Operation_GameCardCommand,
} Operation;

typedef enum
{
    OperationResult_Success,
    OperationResult_Failure,
} OpeartionResult;


// *** StorageInterface
typedef enum
{
    WriteReadAccessType_SEQ,
    WriteReadAccessType_ALT,
    WriteReadAccessType_DEC,
} WriteReadAccessType;

typedef enum
{
    WriteReadPattern_FIX_00,
    WriteReadPattern_FIX_FF,
    WriteReadPattern_FIX_55,
    WriteReadPattern_FIX_AA,
    WriteReadPattern_FIX_0F,
    WriteReadPattern_FIX_F0,
    WriteReadPattern_FIX_5A,
    WriteReadPattern_FIX_A5,
    WriteReadPattern_INC8,
    WriteReadPattern_DEC8,
    WriteReadPattern_INC32,
    WriteReadPattern_DEC32,
    WriteReadPattern_RANDOM,
    WriteReadPattern_AGING,
    WriteReadPattern_NULL,
} WriteReadPattern;

typedef enum
{
    WriteReadMark_ON,
    WriteReadMark_OFF,
    WriteReadMark_NONE,
} WriteReadMark;

typedef enum
{
    WriteReadDirection_Write,
    WriteReadDirection_Read
} WriteReadDirection;

typedef enum
{
    InsertDirection_Insert,
    InsertDirection_Remove,
    InsertDirection_CheckInsert,
    InsertDirection_CheckRemove,
} InsertDirection;

typedef enum
{
    SpeedMode_Identification,
    SpeedMode_MmcLegacySpeed,
    SpeedMode_MmcHighSpeed,
    SpeedMode_MmcHs200,
    SpeedMode_MmcHs400,
    SpeedMode_SdCardDefaultSpeed,
    SpeedMode_SdCardHighSpeed,
    SpeedMode_SdCardSdr12,
    SpeedMode_SdCardSdr25,
    SpeedMode_SdCardSdr50,
    SpeedMode_SdCardSdr104,
    SpeedMode_SdCardDdr50,
    SpeedMode_GcAsicFpgaSpeed,
    SpeedMode_GcAsicSpeed,
    SpeedMode_SdCardIdentification,
} SpeedMode;

typedef enum
{
    MmcPartition_UserData,
    MmcPartition_BootPartition1,
    MmcPartition_BootPartition2,
    MmcPartition_Unknown
} MmcPartition;

typedef enum
{
    WriteParam_GcMemorySize,
} WriteParam;

#include "ArgumentStructure.h"
