﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include <nnt/nntest.h>

#include <nn/sasbus/sasbus.h>

namespace
{
#ifdef NN_BUILD_CONFIG_SPEC_NX
    nn::sasbus::SasbusDevice testDeviceName = nn::sasbus::SasbusDevice_Lsm6ds3;
#else
    // TORIAEZU
    nn::sasbus::SasbusDevice testDeviceName = nn::sasbus::SasbusDevice_Dummy;
#endif
}

//---------------------------------------
// SASBUS ライブラリの Open / Close の基本的なテスト
TEST(testSasbus_Basic, OpenAndClose)
{
    nn::sasbus::Session session;

    nn::sasbus::Initialize();

    nn::sasbus::OpenSession(&session, testDeviceName);

    nn::sasbus::CloseSession(&session);

    nn::sasbus::Finalize();
}

//---------------------------------------
// 複数回の SASBUS ライブラリの Open / Close
TEST(testSasbus_Basic, MultipleOpenClose)
{
    nn::sasbus::Session session;

    for(int i = 0; i < 100; i++)
    {
        nn::sasbus::Initialize();

        nn::sasbus::OpenSession(&session, testDeviceName);

        nn::sasbus::CloseSession(&session);

        nn::sasbus::Finalize();
    }
}
