﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#ifndef _FILEUTILS_H_
#define _FILEUTILS_H_

#pragma once

#include <cstdio>
#include <cstring>
#include <cstdlib>

#include <nn/fs/fs_Directory.h>
#include <nn/fs/fs_File.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Result.h>

extern "C"
{
//  Dummy forward declarations of PRBool and PRFileDesc needed by nnsdk_fsHelper.h
typedef int PRBool;
typedef struct PRFileDesc_ PRFileDesc;
#include "nnsdk_fsHelper.h"
}

typedef enum {
    MAX_FILENAME_LEN  = 256,
} FileUtilConstants;


namespace helperutils
{
const size_t READ_BLOCK_SIZE = 8192;

int64_t ReadLine(nn::fs::FileHandle fh, size_t offset, char *buf, size_t maxSize);

int64_t CopyFile(char *dstName, char *srcName);

}

#endif    //  _FILEUTILS_H_
