﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <string>
#include "executils.h"

extern "C"
{

int doDumpAndCall(const char *name, mainEntry func, int argc, char **argv)
{
    int                         ret;

    ::helperutils::dumpCallInfo(name, argc, argv);
    ret = func(argc, argv);
    return ret;
}

}

namespace helperutils
{

void dumpCallInfo(const char *name, int argc, char **argv)
{
    printf("Calling %s with %d args: ", name, argc);
    for (int i = 0; i < argc; i++)
    {
        printf("\'%s\' ", argv[i]);
    }

    printf("\n");
}


void PrepareCmdArgs(CmdArgsInfo *cmdInfo, int *argc, char **argv, int maxArgv)
{
    int                         i;
    int                         count;

    argv[0] = cmdInfo->execName;
    count = 1;
    for (i = 0; (count < maxArgv) && (*cmdInfo->args[i] != NULL); i++, count++)
    {
        argv[count] = cmdInfo->args[i];
    }

    *argc = count;
}

}
