﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ExecuterTestsBase.h"

// ------------------------------------------------------------------------------------------------
// ExecuterTestsRunWithMultiHosts
// ------------------------------------------------------------------------------------------------
class ExecuterTestsRunWithMultiHosts : public ExecuterTestsBase
{
    static const int  TestPortNumber = 443;
    static const int  HostNameLength = 256;
    static const char TestHosts[][HostNameLength];

    uint32_t                              m_RunCount;
    nn::ssl::Connection::VerifyOption     m_VerifyOption;
    nn::ssl::Connection::SessionCacheMode m_SessionCacheMode;

public:
    ExecuterTestsRunWithMultiHosts(
        nn::ssl::Connection::VerifyOption verifyOption,
        nn::ssl::Connection::SessionCacheMode sessionCacheMode,
        uint32_t count);
    ~ExecuterTestsRunWithMultiHosts();
    void Run();
};


