﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

// 参照用
extern int g_ProtectedVariable;
extern int ProtectedFunc();

int CallProtectedFunc()
{
    return ProtectedFunc();
}

uintptr_t GetProtectedVariableAddress()
{
    return reinterpret_cast<uintptr_t>(&g_ProtectedVariable);
}

// Protected が自分を見ることを検証する
int g_ProtectedVariable2 __attribute__((visibility("protected"))) = 2;
int ProtectedFunc2() __attribute__((visibility("protected")));

int ProtectedFunc2()
{
    return g_ProtectedVariable2;
}

int CallProtectedFunc2()
{
    return ProtectedFunc2();
}

uintptr_t GetProtectedVariableAddress2()
{
    return reinterpret_cast<uintptr_t>(&g_ProtectedVariable2);
}


