﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/gtest/gtest.h>
#include <nnt/nnt_Argument.h>

#include <nn/ro/detail/ro_RoExceptionInfo.h>
#include <nn/nn_Log.h>

extern "C" void nnMain();

namespace {

void PrintExceptionInfo(const nn::ro::detail::ExceptionInfo* info)
{
    NN_LOG("[ExceptionInfo]\n");
    NN_LOG("module Address: 0x%x\n", info->moduleAddress);
    NN_LOG("module Size:    0x%x\n", info->moduleSize);
    NN_LOG("info Offset:  0x%x\n", info->infoOffset);
    NN_LOG("info Size:    0x%x\n", info->infoSize);
}

}

TEST(RoLibrary, LoadTest)
{
    uintptr_t pc;

    nn::ro::detail::ExceptionInfo exceptionInfo;

    // rtld
    // Random に配置されるので、廃止

    // main
    pc = reinterpret_cast<uintptr_t>(nnMain);
    ASSERT_TRUE(nn::ro::detail::GetExceptionInfo(&exceptionInfo, pc));
    PrintExceptionInfo(&exceptionInfo);

    // sdk
    pc = reinterpret_cast<uintptr_t>(nnt::GetHostArgc);
    ASSERT_TRUE(nn::ro::detail::GetExceptionInfo(&exceptionInfo, pc));
    PrintExceptionInfo(&exceptionInfo);

    // pc is not found
    pc = 0;
    ASSERT_TRUE(!nn::ro::detail::GetExceptionInfo(&exceptionInfo, pc));
}

