﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/rid/rid_SystemUpdateApi.h>

class RidTestSystemUpdater
{
public:
    RidTestSystemUpdater() NN_NOEXCEPT;
    ~RidTestSystemUpdater() NN_NOEXCEPT;

    void Start() NN_NOEXCEPT;
    nn::Result GetLastResult() NN_NOEXCEPT
    {
        return m_SystemUpdateResult;
    }

    bool IsUpdateProcessDone() NN_NOEXCEPT
    {
        return m_IsSystemUpdateDone;
    }

    std::string GetState() NN_NOEXCEPT;
    void GetProgress(int64_t& outLoaded, int64_t& outTotal) NN_NOEXCEPT;

private:
    bool m_IsStartUpdate;
    nn::Result m_SystemUpdateResult;
    bool m_IsSystemUpdateDone;

    nn::rid::SystemUpdater m_SystemUpdater;
    nn::os::ThreadType m_UpdateExecutionThread;
};

