﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/rid/rid_ApplicationUpdateApi.h>

class RidTestApplicationUpdater
{
public:
    RidTestApplicationUpdater() NN_NOEXCEPT;
    ~RidTestApplicationUpdater() NN_NOEXCEPT;

    void Start() NN_NOEXCEPT;
    nn::Result GetLastResult() NN_NOEXCEPT
    {
        return m_ApplicationUpdateResult;
    }

    bool IsUpdateProcessDone() NN_NOEXCEPT
    {
        return m_IsApplicationUpdateDone;
    }

    std::string GetState() NN_NOEXCEPT;
    void GetProgress(int64_t& outDone, int64_t& outTotal) NN_NOEXCEPT;

private:
    void CreateTestApplicationAsset(nn::rid::ApplicationAsset outAssetList[], int& outAssetListCount) NN_NOEXCEPT;

private:
    bool m_IsStartUpdate;
    nn::Result m_ApplicationUpdateResult;
    bool m_IsApplicationUpdateDone;

    nn::rid::ApplicationUpdater m_ApplicationUpdater;
    nn::os::ThreadType m_UpdateExecutionThread;
};
