﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

//---------------------------------------------------------------------------
//  テスト用ヘルパー関数
//---------------------------------------------------------------------------

namespace nnt { namespace pwm {

// LCD バックライトに供給する周波数
const int LcdBacklightFrequency = 30 * 1000; // 30kHz

// LCD のバックライトを有効化・無効化します。
bool SetLcdBacklightEnabled(bool enable) NN_NOEXCEPT;

// ファンに供給する周波数
const int FanFrequency = 30 * 1000; // 30kHz

// ファンを有効化・無効化します。
bool SetFanEnabled(bool enable) NN_NOEXCEPT;

}}
