﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  ユーティリティ関数
//---------------------------------------------------------------------------

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/gpio/gpio.h>
#include <nnt/nntest.h>
#include "testPwm_Util-hardware.nx.h"

namespace nnt { namespace pwm {

//---------------------------------------------------------------------------
//  テスト用関数
//---------------------------------------------------------------------------

bool SetLcdBacklightEnabled(bool enable) NN_NOEXCEPT
{
    nn::gpio::Initialize();

    nn::gpio::GpioPadSession session;
    nn::gpio::OpenSession(&session, nn::gpio::GpioPadName_PowLcdBlEn);
    nn::gpio::SetDirection(&session, nn::gpio::Direction_Output);

    bool isPreviouslyEnabled = (nn::gpio::GetValue(&session) == nn::gpio::GpioValue_High);

    if (enable)
    {
        nn::gpio::SetValue(&session, nn::gpio::GpioValue_High);
    }
    else
    {
        nn::gpio::SetValue(&session, nn::gpio::GpioValue_Low);
    }
    nn::gpio::CloseSession(&session);

    // TORIAEZU
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(200));

    nn::gpio::Finalize();

    return isPreviouslyEnabled;
}

bool SetFanEnabled(bool enable) NN_NOEXCEPT
{
    nn::gpio::Initialize();

    nn::gpio::GpioPadSession session;

    // SDEV1 では VDD50B-EN が無効になっており、VDD50A-EN 側から電圧を有効化する必要がある
    nn::gpio::OpenSession(&session, nn::gpio::GpioPadName_Vdd50AEn);
    nn::gpio::SetDirection(&session, nn::gpio::Direction_Output);

    bool isPreviouslyEnabled = (nn::gpio::GetValue(&session) == nn::gpio::GpioValue_High);

    if (enable)
    {
        nn::gpio::SetValue(&session, nn::gpio::GpioValue_High);
    }
    else
    {
        nn::gpio::SetValue(&session, nn::gpio::GpioValue_Low);
    }
    nn::gpio::CloseSession(&session);

    nn::gpio::Finalize();

    return isPreviouslyEnabled;
}

}}  // namespace nnt::pwm
