﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os.h>

#include <nn/psm/driver/psm.h>
#include <nn/psm/psm.h>
#include <nn/psm/psm_SystemProcess.h>

#include <nnt/nntest.h>

#include "testPsm_Common.h"

namespace nnt { namespace psm {

namespace {

struct PsmSystemPowerStatePolicyTestSetting
{
    // conditions
    int batteryVoltage;

    // expected value
    nn::psm::BatteryVoltageState batteryVoltageState;
};

const PsmSystemPowerStatePolicyTestSetting PsmSystemPowerStatePolicyTestSettings[] =
{
    { 3099, nn::psm::BatteryVoltageState_ShutdownRequired               },
    { 3100, nn::psm::BatteryVoltageState_SleepRequired                  },
    { 3200, nn::psm::BatteryVoltageState_BoostPerformanceModeProhibited },
    { 3320, nn::psm::BatteryVoltageState_Good                           },
};

class PsmSystemPowerStatePolicyTest : public ::testing::TestWithParam<PsmSystemPowerStatePolicyTestSetting>
{
public:
    static void SetUpTestCase()
    {
        ::nnt::psm::Initialize();
    }

    static void TearDownTestCase()
    {
        ::nnt::psm::Finalize();
    }
};

INSTANTIATE_TEST_CASE_P(PsmSystemPowerStatePolicyTestName, PsmSystemPowerStatePolicyTest, ::testing::ValuesIn(PsmSystemPowerStatePolicyTestSettings));

} // namespace

TEST_P(PsmSystemPowerStatePolicyTest, CheckChargeSettings)
{
    nn::psm::Session session;
    nn::psm::OpenSession(&session);
    nn::os::SystemEventType systemEvent;
    nn::psm::BindStateChangeEvent(&systemEvent, &session);

    ChangeBatteryVoltageMilliVolt(GetParam().batteryVoltage);

    EXPECT_TRUE(nn::os::TimedWaitSystemEvent(&systemEvent, nn::TimeSpan::FromMilliSeconds(1000)));

    EXPECT_EQ(GetParam().batteryVoltageState, nn::psm::GetBatteryVoltageState());

    nn::psm::UnbindStateChangeEvent(&session);
    nn::psm::CloseSession(&session);
}

}} // namespace nnt::psm
