﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/psm/driver/detail/psm_Constants.h>
#include <nn/psm/driver/psm.h>
#include <nn/psm/psm.h>
#include <nn/psm/psm_SystemProcessApi.h>

#include <nnt/base/testBase_Exit.h>
#include <nnt/nnt_Argument.h>

#include <nnt/nntest.h>

#include "psm_ChargerDriver.h"
#include "testPsm_ChargerDriverStub.h"
#include "testPsm_Common.h"

namespace nnt { namespace psm {

namespace {

struct PsmChargeCurrentLimitPolicyTestSetting
{
    //! 電池温度（境界確認）
    double batteryTemperatureCelsius;

    //! 電池電圧（境界確認）
    int batteryVoltageMilliVolt;

    //! システム電源状態（主要なステートの確認）
    ::nn::psc::PmState systemPowerState;

    //! 高速充電可否（境界確認）
    bool fastBatteryChargingEnabled;

    //! 充電電流の期待値
    int chargeCurrentLimitMilliAmpere;

    //! 充電電流オプションの期待値
    ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption chargeCurrentLimitOption;
};

const PsmChargeCurrentLimitPolicyTestSetting PsmChargeCurrentLimitPolicyTestSettings[] =
{
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3320, ::nn::psc::PmState_FullAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateDefault, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3320, ::nn::psc::PmState_FullAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereLowTemperature,    ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3319, ::nn::psc::PmState_FullAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3319, ::nn::psc::PmState_FullAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },

    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3320, ::nn::psc::PmState_FullAwake, false, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3320, ::nn::psc::PmState_FullAwake, false, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3319, ::nn::psc::PmState_FullAwake, false, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3319, ::nn::psc::PmState_FullAwake, false, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },

    // SHOULD BE FIXED: FastChargeCurrentLimitMilliAmpereAwakeStateLow に二つの意味があり 3.32V 以下での制限の意味を定数名が表現していない。
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3320, ::nn::psc::PmState_MinimumAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateDefault, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3320, ::nn::psc::PmState_MinimumAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereLowTemperature,    ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3319, ::nn::psc::PmState_MinimumAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3319, ::nn::psc::PmState_MinimumAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },

    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3320, ::nn::psc::PmState_SleepReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateDefault, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3320, ::nn::psc::PmState_SleepReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereLowTemperature,    ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3319, ::nn::psc::PmState_SleepReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3319, ::nn::psc::PmState_SleepReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },

    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3320, ::nn::psc::PmState_ShutdownReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateDefault, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3320, ::nn::psc::PmState_ShutdownReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereLowTemperature,    ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3319, ::nn::psc::PmState_ShutdownReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow - 0.1, 3319, ::nn::psc::PmState_ShutdownReady, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateLow,     ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::None },

    // 順次実行時の ShutdownReady からの復帰確認
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,       3320, ::nn::psc::PmState_FullAwake, true, ::nn::psm::driver::detail::FastChargeCurrentLimitMilliAmpereAwakeStateDefault, ::nn::psm::driver::detail::ChargerDriver::FastChargeCurrentLimitOption::Current20Percent },
};

class PsmChargeCurrentLimitPolicyTest : public ::testing::TestWithParam<PsmChargeCurrentLimitPolicyTestSetting>
{
public:
    static void SetUpTestCase()
    {
        ::nnt::psm::Initialize();
    }

    static void TearDownTestCase()
    {
        ::nnt::psm::Finalize();
    }
};

INSTANTIATE_TEST_CASE_P(PsmChargeCurrentLimitPolicyTestName, PsmChargeCurrentLimitPolicyTest, ::testing::ValuesIn(PsmChargeCurrentLimitPolicyTestSettings));

} // namespace

TEST_P(PsmChargeCurrentLimitPolicyTest, CheckChargeSettings)
{
    TransitPmState(GetParam().systemPowerState, true);

    ChangeBatteryTemperature(GetParam().batteryTemperatureCelsius);
    ChangeBatteryVoltageMilliVolt(GetParam().batteryVoltageMilliVolt);

    if ( GetParam().fastBatteryChargingEnabled )
    {
        ::nn::psm::EnableFastBatteryCharging();
    }
    else
    {
        ::nn::psm::DisableFastBatteryCharging();
    }

    TransitPmState(GetParam().systemPowerState);

    EXPECT_EQ(GetParam().chargeCurrentLimitMilliAmpere, driver::detail::GetChargeCurrentLimitMilliAmpere());
    EXPECT_EQ(GetParam().chargeCurrentLimitOption,      driver::detail::GetChargeCurrentLimitOption());
}

}} // namespace nnt::psm
