﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/psm/psm.h>
#include <nn/psm/psm_Manufacture.h>
#include <nn/psm/psm_System.h>
#include <nn/psm/psm_SystemProcess.h>
#include <nnt/nntest.h>

namespace {

void OutputCurrentBatteryVoltageState() NN_NOEXCEPT
{
    auto batteryVoltageState = ::nn::psm::GetBatteryVoltageState();

    const char* batteryVoltageStateName = nullptr;
    switch (batteryVoltageState)
    {
    case ::nn::psm::BatteryVoltageState_ShutdownRequired:
        batteryVoltageStateName = "ShutdownRequired";
        break;
    case ::nn::psm::BatteryVoltageState_SleepRequired:
        batteryVoltageStateName = "SleepRequired";
        break;
    case ::nn::psm::BatteryVoltageState_BoostPerformanceModeProhibited:
        batteryVoltageStateName = "BoostPerformanceModeProhibited";
        break;
    case ::nn::psm::BatteryVoltageState_Good:
        batteryVoltageStateName = "Good";
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
    NN_LOG("PSM Test: battery voltage state: %s\n", batteryVoltageStateName);
}

} // namespace

// BatteryVoltageState の変化を 6 回出力します。
// SDEV を使用して HostBridge から VCELL を操作し BatteryVoltageState の変化を確認してください。
TEST(PsmManualTest, BatteryVoltageState)
{
    ::nn::psm::Initialize();

    ::nn::psm::Session session;
    ::nn::psm::OpenSession(&session);

    ::nn::os::SystemEventType event;
    ::nn::psm::BindStateChangeEvent(&event, &session);
    ::nn::psm::SetChargerTypeChangeEventEnabled(&session, false);
    ::nn::psm::SetPowerSupplyChangeEventEnabled(&session, false);
    ::nn::psm::SetBatteryVoltageStateChangeEventEnabled(&session, true);

    auto previousBatteryVoltageState = ::nn::psm::GetBatteryVoltageState();

    auto count = 0;

    while ( count < 6 )
    {
        NN_LOG("PSM Test: please change VCELL value.\n");

        ::nn::os::WaitSystemEvent(&event);
        ::nn::os::ClearSystemEvent(&event);

        auto currentBatteryVoltageState = ::nn::psm::GetBatteryVoltageState();

        if ( currentBatteryVoltageState != previousBatteryVoltageState )
        {
            OutputCurrentBatteryVoltageState();

            count++;
        }

        previousBatteryVoltageState = currentBatteryVoltageState;
    }

    ::nn::psm::UnbindStateChangeEvent(&session);

    ::nn::psm::CloseSession(&session);

    ::nn::psm::Finalize();
}
