﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os.h>

namespace nn { namespace tcap {

nn::os::SystemEventType g_ContinuousHighSkinTemperatureEvent;

void Initialize() NN_NOEXCEPT
{
    nn::os::CreateSystemEvent(&g_ContinuousHighSkinTemperatureEvent, nn::os::EventClearMode_ManualClear, true);
}

void Finalize() NN_NOEXCEPT
{
    nn::os::DestroySystemEvent(&g_ContinuousHighSkinTemperatureEvent);
}

void GetContinuousHighSkinTemperatureEvent(nn::os::SystemEventType* pOutSystemEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    nn::os::AttachReadableHandleToSystemEvent(pOutSystemEvent,
        nn::os::GetReadableHandleOfSystemEvent(&g_ContinuousHighSkinTemperatureEvent), false, clearMode);
}

void SignalContinuousHighSkinTemperatureEvent() NN_NOEXCEPT
{
    nn::os::SignalSystemEvent(&g_ContinuousHighSkinTemperatureEvent);
}

}} // namespace nn::tcap
