﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/cec/cec_Api.h>

namespace {
    nn::os::SystemEventType* g_pCecAsynchronousSystemEvent = nullptr;
    nn::cec::BusEventType g_BusEvent = nn::cec::BusEventType_Ignore;
}

namespace nn { namespace cec {

nn::Result Initialize(nn::os::SystemEventType* pCecAsynchronousSystemEvent) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(pCecAsynchronousSystemEvent);
    nn::os::CreateSystemEvent(pCecAsynchronousSystemEvent, nn::os::EventClearMode_AutoClear, true);
    g_pCecAsynchronousSystemEvent = pCecAsynchronousSystemEvent;
    NN_RESULT_SUCCESS;
}

nn::Result Finalize() NN_NOEXCEPT
{
    nn::os::DestroySystemEvent(g_pCecAsynchronousSystemEvent);
    g_pCecAsynchronousSystemEvent = nullptr;
    NN_RESULT_SUCCESS;
}

nn::Result GetBusEventType(BusEventType* pOutEventType) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(pOutEventType);
    *pOutEventType = g_BusEvent;
    NN_RESULT_SUCCESS;
}

}} // namespace nn::cec

// 以下テスト環境専用

namespace nnt { namespace psm {

void SignalSystemStandby(nn::cec::BusEventType event) NN_NOEXCEPT
{
    g_BusEvent = event;
    nn::os::SignalSystemEvent(g_pCecAsynchronousSystemEvent);
}

}} // namespace nnt::cec
