﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace soctherm {

#define NNT_DETAIL_SOCTHERM_REGISTER(name, offset) \
{ \
    #name, (offset) \
}

struct SocthermRegister
{
    char name[64];
    size_t offset;
};

// NOTICE: 作業量の都合上 SIGLO-48459 にて疑義がある THERMCTL 側のレジスタのみを対象とする。
const SocthermRegister SocthermRegisterList[] =
{
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL0_GROUP_CPU_0,    0x0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL0_GROUP_GPU_0,    0x4),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL0_GROUP_MEM_0,    0x8),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL0_GROUP_TSENSE_0, 0xC),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL0_UP_STATS_0,     0x10),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL0_DN_STATS_0,     0x14),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL1_GROUP_CPU_0,    0x20),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL1_GROUP_GPU_0,    0x24),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL1_GROUP_MEM_0,    0x28),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL1_GROUP_TSENSE_0, 0x2C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL1_UP_STATS_0,     0x30),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL1_DN_STATS_0,     0x34),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL2_GROUP_CPU_0,    0x40),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL2_GROUP_GPU_0,    0x44),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL2_GROUP_MEM_0,    0x48),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL2_GROUP_TSENSE_0, 0x4C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL2_UP_STATS_0,     0x50),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL2_DN_STATS_0,     0x54),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL3_GROUP_CPU_0,    0x60),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL3_GROUP_GPU_0,    0x64),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL3_GROUP_MEM_0,    0x68),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL3_GROUP_TSENSE_0, 0x6C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL3_UP_STATS_0,     0x70),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_LEVEL3_DN_STATS_0,     0x74),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_THERMTRIP_CTL_0,       0x80),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_INTR_STATUS_0,         0x84),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_INTR_EN_0,             0x88),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_INTR_DIS_0,            0x8C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_STATS_CTL_0,           0x94),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_SLOWDOWN_THRESHOLD_0,  0x98),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_THERMCTL_SLOWDOWN_CTL_0,        0x9C),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU0_CONFIG0_0,         0xC0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU0_CONFIG1_0,         0xC4),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU0_CONFIG2_0,         0xC8),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU0_STATUS0_0,         0xCC),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU0_STATUS1_0,         0xD0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU0_STATUS2_0,         0xD4),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU1_CONFIG0_0,         0xE0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU1_CONFIG1_0,         0xE4),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU1_CONFIG2_0,         0xE8),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU1_STATUS0_0,         0xEC),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU1_STATUS1_0,         0xF0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU1_STATUS2_0,         0xF4),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU2_CONFIG0_0,         0x100),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU2_CONFIG1_0,         0x104),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU2_CONFIG2_0,         0x108),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU2_STATUS0_0,         0x10C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU2_STATUS1_0,         0x110),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU2_STATUS2_0,         0x114),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU3_CONFIG0_0,         0x120),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU3_CONFIG1_0,         0x124),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU3_CONFIG2_0,         0x128),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU3_STATUS0_0,         0x12C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU3_STATUS1_0,         0x130),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CPU3_STATUS2_0,         0x134),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM0_CONFIG0_0,         0x140),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM0_CONFIG1_0,         0x144),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM0_CONFIG2_0,         0x148),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM0_STATUS0_0,         0x14C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM0_STATUS1_0,         0x150),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM0_STATUS2_0,         0x154),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM1_CONFIG0_0,         0x160),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM1_CONFIG1_0,         0x164),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM1_CONFIG2_0,         0x168),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM1_STATUS0_0,         0x16C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM1_STATUS1_0,         0x170),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_MEM1_STATUS2_0,         0x174),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_GPU_CONFIG0_0,          0x180),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_GPU_CONFIG1_0,          0x184),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_GPU_CONFIG2_0,          0x188),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_GPU_STATUS0_0,          0x18C),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_GPU_STATUS1_0,          0x190),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_GPU_STATUS2_0,          0x194),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_CONFIG0_0,         0x1A0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_CONFIG1_0,         0x1A4),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_CONFIG2_0,         0x1A8),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_STATUS0_0,         0x1AC),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_STATUS1_0,         0x1B0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_STATUS2_0,         0x1B4),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PDIV_0,                 0x1C0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_HOTSPOT_OFF_0,          0x1C4),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_TEMP1_0,                0x1C8),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_TEMP2_0,                0x1CC),

    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PWR_VLD_OVERRIDE_0,     0x1D0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_SPARE_ECO_0,            0x1D4),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_TEMP_SW_OVERRIDE_0,     0x1D8),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_CLKEN_0,                0x1DC),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_VALID_0,                0x1E0),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_HW_PLLX_OFFSETTING_0,   0x1E4),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_OFFSET_MIN_0,      0x1E8),
    NNT_DETAIL_SOCTHERM_REGISTER(SOC_THERM_TSENSOR_PLLX_OFFSET_MAX_0,      0x1EC),
};

}} // namespace nnt::soctherm
