﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nnt/nntest.h>

#include "testOe_Init.h"
#include "testOe_PerformanceConfigurationTestForSdkUsers.h"

namespace nnt { namespace oe {

namespace {

INSTANTIATE_TEST_CASE_P(ConfigInfos, PerformanceConfigurationTestForSdkUsers, ::testing::ValuesIn(ConfigInfoListForSdkUsers));

} // namespace

TEST_P(PerformanceConfigurationTestForSdkUsers, SetConfigAndCheckFrequencies)
{
    SetConfigAndCheckFrequencies(GetParam());
}

TEST_P(PerformanceConfigurationTestForSdkUsers, SetConfigAndCheckFrequenciesOnNormal)
{
    SetConfigAndCheckFrequenciesOnNormal(GetParam());
}

TEST_P(PerformanceConfigurationTestForSdkUsers, SetConfigAndCheckFrequenciesOnBoost)
{
    SetConfigAndCheckFrequenciesOnBoost(GetParam());
}

}} // namespace nnt::oe
