﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

#include <nn/fgm/fgm.h>

#include <nnt/nntest.h>

namespace nnt { namespace apm { namespace server {

namespace {

// 値取得用のリクエスト。
nn::fgm::Request g_RequestCpu;
nn::fgm::Request g_RequestGpu;
nn::fgm::Request g_RequestEmc;

} // namespace

void CheckFrequencies(nn::fgm::Setting cpuSetting, nn::fgm::Setting gpuSetting, nn::fgm::Setting emcSetting) NN_NOEXCEPT
{
    nn::fgm::Setting setting = 0;

    EXPECT_TRUE(g_RequestCpu.Get(&setting).IsSuccess());
    //NN_LOG("Current Cpu Setting Rate: %d\n", setting);
    EXPECT_EQ(cpuSetting, setting);

    setting = 0;

    EXPECT_TRUE(g_RequestGpu.Get(&setting).IsSuccess());
    //NN_LOG("Current Gpu Setting Rate: %d\n", setting);
    EXPECT_EQ(gpuSetting, setting);

    setting = 0;

    EXPECT_TRUE(g_RequestEmc.Get(&setting).IsSuccess());
    //NN_LOG("Current Emc Setting Rate: %d\n", setting);
    EXPECT_EQ(emcSetting, setting);
}

void SetUp() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestCpu.Initialize(nn::fgm::Module_Cpu, nn::fgm::Priority_Default));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestGpu.Initialize(nn::fgm::Module_Gpu, nn::fgm::Priority_Default));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestEmc.Initialize(nn::fgm::Module_Emc, nn::fgm::Priority_Default));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestCpu.SetAndWait(static_cast<nn::fgm::Setting>(nn::fgm::Setting_Min), static_cast<nn::fgm::Setting>(nn::fgm::Setting_Max)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestGpu.SetAndWait(static_cast<nn::fgm::Setting>(nn::fgm::Setting_Min), static_cast<nn::fgm::Setting>(nn::fgm::Setting_Max)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestEmc.SetAndWait(static_cast<nn::fgm::Setting>(nn::fgm::Setting_Min), static_cast<nn::fgm::Setting>(nn::fgm::Setting_Max)));
}

void TearDown() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestCpu.Finalize());
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestGpu.Finalize());
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_RequestEmc.Finalize());
}

}}} // namespace nnt::apm::server
