﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nntest.h>
#include <nn/pdm/pdm_Api.h>

using namespace nn;

namespace {
    void DumpApplicationPlayStatistics(const pdm::ApplicationPlayStatistics& statistics)
    {
        NN_LOG("ApplicationId : 0x%016llx\n", statistics.applicationId);
        NN_LOG("Play Count    : %d\n", statistics.totalPlayCount);
        NN_LOG("Play Time     : %lld seconds\n", statistics.totalPlayTime.GetSeconds());
    }
}

// .nmeta 権限チェック手元確認用。.nmeta の設定によって異なる場所でアボートする。

TEST(PdmQueryApplicationTest, Basic)
{
    pdm::ApplicationPlayStatistics applicationPlayStatistics;
    {
        // None でも自分自身へのクエリは可。
        nn::ApplicationId applicationId{ 0x01004b9000490000 };
        auto count = pdm::QueryApplicationPlayStatistics(&applicationPlayStatistics, &applicationId, 1);
        EXPECT_EQ(1, count);
        DumpApplicationPlayStatistics(applicationPlayStatistics);
    }
    {
        // None はここで Abort する。
        nn::ApplicationId applicationId{ 0x01004b9000490001 };
        auto count = pdm::QueryApplicationPlayStatistics(&applicationPlayStatistics, &applicationId, 1);
        EXPECT_EQ(1, count);
        DumpApplicationPlayStatistics(applicationPlayStatistics);
    }
    {
        // WhiteList はここで Abort する。
        nn::ApplicationId applicationId{ 0x01004b9000490002 };
        auto count = pdm::QueryApplicationPlayStatistics(&applicationPlayStatistics, &applicationId, 1);
        EXPECT_EQ(1, count);
        DumpApplicationPlayStatistics(applicationPlayStatistics);
    }
}
