﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>
#include <nn/pdm/pdm_SystemTypes.h>
#include <nn/pdm/pdm_PrivateTypes.h>
#include <nn/time.h>
#include <nnt.h>

using namespace nn;
using namespace nn::pdm;

#define NNT_PDM_EXPECT_PLAYSTAT_EQ(stat, id, count, time, fIndex, fUserClock, fNetClock, lIndex, lUserClock, lNetClock) \
    do { \
        EXPECT_EQ(id, stat.applicationId); \
        EXPECT_EQ(count, stat.totalPlayCount); \
        EXPECT_EQ(time, stat.totalPlayTime); \
        EXPECT_EQ(fIndex, stat.firstEventTime.eventIndex); \
        EXPECT_EQ(fUserClock, stat.firstEventTime.userClockTime); \
        EXPECT_EQ(fNetClock, stat.firstEventTime.networkClockTime); \
        EXPECT_EQ(lIndex, stat.latestEventTime.eventIndex); \
        EXPECT_EQ(lUserClock, stat.latestEventTime.userClockTime); \
        EXPECT_EQ(lNetClock, stat.latestEventTime.networkClockTime); \
    } while( NN_STATIC_CONDITION(false) )


#define NNT_PDM_EXPECT_APP_PLAYSTAT_EQ(stat, id, count, timeInMinutes) \
    do { \
        EXPECT_EQ(id.value, stat.applicationId.value); \
        EXPECT_EQ(count, stat.totalPlayCount); \
        EXPECT_EQ(timeInMinutes, stat.totalPlayTime.GetMinutes()); \
    } while( NN_STATIC_CONDITION(false) )


#define NNT_PDM_EXEPCT_LASTPLAYTIME_EQ(last, id, userClock, netClock, isElapsedAvailable, elapsed) \
    do { \
        EXPECT_EQ(id.value, last.applicationId.value); \
        EXPECT_EQ(userClock, last.userClockTime); \
        EXPECT_EQ(netClock, last.networkClockTime); \
        EXPECT_EQ(isElapsedAvailable, last.isElapsedMinutesAvailable); \
        if(last.isElapsedMinutesAvailable) \
        { \
            /* イベント追加から EQ 実行までの間隔によってズレが生じるので EQ ではなく NEAR を使う  */ \
            EXPECT_NEAR(elapsed, last.elapsedMinutesSinceLastPlay, 1); \
        } \
    } while( NN_STATIC_CONDITION(false) )


namespace nnt { namespace pdm {

PlayEvent MakeAppletEvent(AppletEventType eventType, const nn::ncm::ProgramId& programId, uint32_t version, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeLibraryAppletEvent(AppletEventType eventType, const nn::ncm::ProgramId& mainProgramId, nn::applet::LibraryAppletMode libraryAppletMode, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeUserAccountEvent(UserAccountEventType eventType, const nn::account::Uid& user, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakePowerStateChangeEvent(PowerStateChangeEventType eventType, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;

PlayEvent MakeAppletEventInMinutes(AppletEventType eventType, const nn::ncm::ProgramId& programId, uint32_t version, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy,
        int64_t userClockTimeValue, int64_t networkClockTimeValue, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeLibraryAppletEventInMinutes(AppletEventType eventType, const nn::ncm::ProgramId& mainProgramId, nn::applet::LibraryAppletMode libraryAppletMode, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy,
    int64_t userClockTimeValue, int64_t networkClockTimeValue, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeUserAccountEventInMinutes(UserAccountEventType eventType, const nn::account::Uid& user,
        int64_t userClockTimeValue, int64_t networkClockTimeValue, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakePowerStateChangeEventInMinutes(PowerStateChangeEventType eventType,
    int64_t userClockTimeValue, int64_t networkClockTimeValue, int64_t steadyClockTime) NN_NOEXCEPT;

}}
