﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>
#include "../Common/ModuleInfo.h"
#include "../Common/ModuleNames.h"

using namespace nnt::pcv;

//Prints info for each IP
// <IP Name>, <Current State>, Range(<Min>, <Max>)
TEST(PcvSampleTest, AllModules)
{
    // Pcv library should already be initialized
    ASSERT_TRUE(nn::pcv::IsInitialized());

    nn::Result r;
    nn::pcv::ModuleState currentModuleState;

    nn::pcv::ClockRatesListType listType = nn::pcv::ClockRatesListType_Invalid;
    nn::pcv::ClockHz rates[nn::pcv::MaxNumClockRates];
    memset(rates, 0, sizeof(rates) / sizeof(rates[0]));

    int numRates = 0;

    NN_LOG("%-25s%-20s%-20s","Module",  "Current State (MHz)" , "Frequency Range(MHz)\n");
    for (int moduleId = 0; moduleId < nn::pcv::Module_NumModule; ++moduleId)
    {
        nn::pcv::Module currentModule = static_cast<nn::pcv::Module>(moduleId);
        currentModuleState = {0};
        r = nn::pcv::GetState(&currentModuleState, currentModule);
        if (r.IsFailure())
        {
            NN_LOG("%-20s Not Supported.\n",
                GetModuleName(currentModule));
        }
        else
        {
            r = nn::pcv::GetPossibleClockRates(
                &listType,
                rates,
                &numRates,
                currentModule,
                nn::pcv::MaxNumClockRates);

            if (r.IsFailure())
            {
                NN_LOG("Failed to GetPossibleClockRates with module: %s\n",
                    GetModuleName(currentModule));
            }
            else
            {
                NN_LOG("%-25s", GetModuleName(currentModule));
                if (!currentModuleState.powerEnabled)
                    NN_LOG("%-20s", "PowerEnabled OFF");
                if (!currentModuleState.clockEnabled)
                    NN_LOG("%-20s", "ClockEnabled OFF");
                else
                    NN_LOG("%-20.2f", currentModuleState.clockFrequency / (1000.0 * 1000.0));

                NN_LOG("(%-6.2f, %-6.2f)\n",
                    (rates[0] > 0 ? rates[0] : rates[numRates - 1]) / (1000.0 * 1000.0),
                    rates[numRates - 1] / (1000.0 * 1000.0));
            }
        }
    }
}

