﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pcv/pcv.h>

namespace nnt {
namespace pcv {

    // Type of frequency list
    enum ListType
    {
        ListNotSupported,
        Discrete,   // list of exact frequencies
        NonDiscrete, // {0, max}
    };

    enum SetType
    {
        SetNotSupported,
        Ceiling,
        Floor,
        Exact,
    };

    // Each module has specfic ListType of frequency rates
    struct ModuleInfo
    {
        nn::pcv::Module name;
        ListType ratesListType;
        SetType setClockType;
    };

    const ModuleInfo ModuleInfoList[] =
    {
        { nn::pcv::Module_Cpu,               Discrete,         Ceiling          },
        { nn::pcv::Module_Gpu,               Discrete,         Ceiling          },
        { nn::pcv::Module_I2s1,              NonDiscrete,      Floor            },
        { nn::pcv::Module_I2s2,              NonDiscrete,      Floor            },
        { nn::pcv::Module_I2s3,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Pwm,               NonDiscrete,      Floor            },
        { nn::pcv::Module_I2c1,              NonDiscrete,      Floor            },
        { nn::pcv::Module_I2c2,              NonDiscrete,      Floor            },
        { nn::pcv::Module_I2c3,              NonDiscrete,      Floor            },
        { nn::pcv::Module_I2c4,              NonDiscrete,      Floor            },
        { nn::pcv::Module_I2c5,              NonDiscrete,      Floor            },
        { nn::pcv::Module_I2c6,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Spi1,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Spi2,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Spi3,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Spi4,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Disp1,             NonDiscrete,      Exact            },
        { nn::pcv::Module_Disp2,             NonDiscrete,      Exact            },
        { nn::pcv::Module_Isp,               ListNotSupported, SetNotSupported  },
        { nn::pcv::Module_Vi,                ListNotSupported, SetNotSupported  },
        { nn::pcv::Module_Sdmmc1,            NonDiscrete,      Floor            },
        { nn::pcv::Module_Sdmmc2,            NonDiscrete,      Floor            },
        { nn::pcv::Module_Sdmmc3,            NonDiscrete,      Floor            },
        { nn::pcv::Module_Sdmmc4,            NonDiscrete,      Floor            },
        { nn::pcv::Module_Owr,               ListNotSupported, SetNotSupported  },
        { nn::pcv::Module_Csite,             NonDiscrete,      Floor            },
        { nn::pcv::Module_Tsec,              Discrete,         Ceiling          },
        { nn::pcv::Module_Mselect,           Discrete,         Ceiling          },
        { nn::pcv::Module_Hda2codec2x,       NonDiscrete,      Floor            },
        { nn::pcv::Module_Actmon,            NonDiscrete,      Floor            },
        { nn::pcv::Module_I2cSlow,           NonDiscrete,      Floor            },
        { nn::pcv::Module_Sor1,              NonDiscrete,      Exact            },
        { nn::pcv::Module_Sata,              ListNotSupported, SetNotSupported  },
        { nn::pcv::Module_Hda,               NonDiscrete,      Floor            },
        { nn::pcv::Module_XusbCoreHostSrc,   NonDiscrete,      Floor            },
        { nn::pcv::Module_XusbFalconSrc,     NonDiscrete,      Floor            },
        { nn::pcv::Module_XusbFsSrc,         NonDiscrete,      Floor            },
        { nn::pcv::Module_XusbCoreDevSrc,    NonDiscrete,      Floor            },
        { nn::pcv::Module_XusbSsSrc,         NonDiscrete,      Floor            },
        { nn::pcv::Module_UartA,             NonDiscrete,      Floor            },
        { nn::pcv::Module_UartB,             NonDiscrete,      Floor            },
        { nn::pcv::Module_UartC,             NonDiscrete,      Floor            },
        { nn::pcv::Module_UartD,             NonDiscrete,      Floor            },
        { nn::pcv::Module_Hostx,             Discrete,         Ceiling          },
        { nn::pcv::Module_Entropy,           NonDiscrete,      Floor            },
        { nn::pcv::Module_SocTherm,          NonDiscrete,      Floor            },
        { nn::pcv::Module_Vic,               Discrete,         Ceiling          },
        { nn::pcv::Module_Nvenc,             Discrete,         Ceiling          },
        { nn::pcv::Module_Nvjpg,             Discrete,         Ceiling          },
        { nn::pcv::Module_Nvdec,             Discrete,         Ceiling          },
        { nn::pcv::Module_Qspi,              NonDiscrete,      Floor            },
        { nn::pcv::Module_ViI2c,             ListNotSupported, SetNotSupported  },
        { nn::pcv::Module_Tsecb,             Discrete,         Ceiling          },
        { nn::pcv::Module_Ape,               Discrete,         Ceiling          },
        { nn::pcv::Module_AudioDsp,          Discrete,         Ceiling          },
        { nn::pcv::Module_AudioUart,         NonDiscrete,      Floor            },
        { nn::pcv::Module_Emc,               Discrete,         Ceiling          },
        { nn::pcv::Module_Plle,              Discrete,         SetNotSupported  }, // S/w fixed rate
        { nn::pcv::Module_PlleHwSeq,         Discrete,         SetNotSupported  }, // S/w fixed rate
        { nn::pcv::Module_Dsi,               NonDiscrete,      SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_Maud,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Dpaux1,            Discrete,         SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_MipiCal,           Discrete,         SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_UartFstMipiCal,    NonDiscrete,      Floor            },
        { nn::pcv::Module_Osc,               Discrete,         SetNotSupported  }, // Fixed rate
        { nn::pcv::Module_SysBus,            Discrete,         Ceiling       },
        { nn::pcv::Module_SorSafe,           Discrete,         SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_XusbSs,            NonDiscrete,      SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_XusbHost,          NonDiscrete,      SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_XusbDevice,        NonDiscrete,      SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_Extperiph1,        NonDiscrete,      Floor            },
        { nn::pcv::Module_Ahub,              NonDiscrete,      Floor            },
        { nn::pcv::Module_Hda2hdmicodec,     NonDiscrete,      SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_Gpuaux,            Discrete,         SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_UsbD,              Discrete,         SetNotSupported  }, // S/w fixed rate
        { nn::pcv::Module_Usb2,              Discrete,         SetNotSupported  }, // S/w fixed rate
        { nn::pcv::Module_Pcie,              Discrete,         SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_Afi,               Discrete,         SetNotSupported  }, // Gate with no rate control
        { nn::pcv::Module_PciExClk,          Discrete,         SetNotSupported  }, // Reset only
        { nn::pcv::Module_PExUsbPhy,         Discrete,         SetNotSupported  }, // Reset only
        { nn::pcv::Module_XUsbPadCtl,        Discrete,         SetNotSupported  }, // Reset only
        { nn::pcv::Module_Apbdma,            Discrete,         SetNotSupported  }, // Gate with no rate control
//      { nn::pcv::Module_Usb2TrkClk,        *,                *                }, // TODO: Fill ListType and ClockType
//      { nn::pcv::Module_XUsbIoPll,         *,                *                }, // TODO: Fill ListType and ClockType
//      { nn::pcv::Module_XUsbIoPllHwSeq,    *,                *                }, // TODO: Fill ListType and ClockType
        { nn::pcv::Module_Cec,               Discrete,         SetNotSupported  }, // Gate with no rate control
    };
} // pcvbasic
} // nnt
