﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nsd/nsd_ApiForTest.h>
#include <nn/os/os_ThreadApi.h>
#include <nn/pctl/pctl_Api.h>
#include <nn/pctl/pctl_ApiSystem.h>
#include <nn/pctl/pctl_ApiForAuthentication.h>
#include <nn/pctl/detail/ipc/pctl_IpcConfig.h>
#include <nn/pctl/detail/service/pctl_IpcServer.h>
#include <nn/pctl/detail/service/pctl_ServiceMain.h>
#include <nn/pctl/detail/service/pctl_ServiceWatcher.h>
#include <nn/pctl/detail/service/common/pctl_SystemInfo.h>
#include <nn/init.h>

using namespace nn::pctl::detail::service;

TEST(PostEvents, Initialize)
{
#if defined(NN_BUILD_CONFIG_OS_WIN)
    nn::nsd::SetTd1EnvironmentForTest();
#endif

    InitializeAllocatorForServer();
    InitializeMain();
    InitializeWatcher();
}

TEST(PostEvents, TestMain)
{
    if (!g_pWatcher->GetNetworkManager().IsPairingActive())
    {
        return;
    }

    nn::time::PosixTime time;
    if (!common::GetNetworkTime(&time))
    {
        return;
    }
    common::SetNetworkTimeForDebug(true, time);

    const nn::ncm::ApplicationId appId = { 0x0100000010001000 };
    time.value += 600;
    common::SetNetworkTimeForDebug(true, time);
    g_pWatcher->GetWatcherEventStorage().AddApplicationPlayedEvent(appId);

    time.value += 1200;
    common::SetNetworkTimeForDebug(true, time);
    g_pWatcher->GetWatcherEventStorage().AddOfflineEvent();

    time.value += 1200;
    common::SetNetworkTimeForDebug(true, time);
    g_pWatcher->GetWatcherEventStorage().AddOnlineEvent();

    time.value += 600;
    common::SetNetworkTimeForDebug(true, time);
    g_pWatcher->GetWatcherEventStorage().AddApplicationPlayedEvent(appId);

    g_pWatcher->GetNetworkManager().RequestPostEventsBackground();

    nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));

    NNT_EXPECT_RESULT_SUCCESS(g_pWatcher->GetNetworkManager().WaitForBackgroundTaskForTest());

    common::SetNetworkTimeForDebug(false, time);
}

TEST(PostEvents, Finalize)
{
    FinalizeWatcher();
    FinalizeMain();
}
