﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <cstdint>

typedef std::int8_t     s8;
typedef std::int16_t    s16;
typedef std::int32_t    s32;
typedef std::int64_t    s64;
typedef std::uint8_t    u8;
typedef std::uint16_t   u16;
typedef std::uint32_t   u32;
typedef std::uint64_t   u64;

namespace DemoUtil {

const int OsMaxThreadNum    = 5;    //!< デモで生成するスレッド数
const int OsThreadStackSize = 4096; //!< デモで生成するスレッドのスタックサイズ

/*!
  @brief        複数のスレッドを作成します。

                func をスレッド関数とするスレッドを num 個作成します。
                スレッドスタックのサイズ、作成できるスレッドの上限は固定です。

                CreateThreads で作成したスレッドが破棄される前に
                再度CreateThreads を呼ぶと、
                以前のスレッドスタックを上書きしてしまうので注意が必要です。

  @param[in]    threads     スレッドオブジェクトの配列
  @param[in]    func        スレッド関数
  @param[in]    num         作成するスレッドの個数

  @return       なし。
*/
void CreateThreads(nn::os::ThreadType* threads, nn::os::ThreadFunction func, u32 num);


/*!
  @brief        複数のスレッドを結合します。

                num 個のスレッドの終了を待ち、結合します。

  @param[in]    threads     スレッドオブジェクトの配列
  @param[in]    num         結合するスレッドの個数

  @return       なし。
*/
void WaitThreads(nn::os::ThreadType* threads, u32 num);

/*!
  @brief        複数のスレッドを破棄します。

  @param[in]    threads     スレッドオブジェクトの配列
  @param[in]    num         破棄するスレッドの個数

  @return       なし。
*/
void DestroyThreads(nn::os::ThreadType* threads, u32 num);


void DumpObjectCounts();


}


